/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.core.internal;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import software.amazon.lambda.powertools.core.internal.SystemWrapper;

public final class LambdaHandlerProcessor {
    private static String SERVICE_NAME = System.getenv("POWERTOOLS_SERVICE_NAME") != null ? System.getenv("POWERTOOLS_SERVICE_NAME") : "service_undefined";
    private static Boolean IS_COLD_START = null;

    private LambdaHandlerProcessor() {
    }

    public static boolean isHandlerMethod(ProceedingJoinPoint pjp) {
        return "handleRequest".equals(pjp.getSignature().getName()) || "requestHandler".equals(pjp.getSignature().getName());
    }

    public static boolean placedOnRequestHandler(ProceedingJoinPoint pjp) {
        return RequestHandler.class.isAssignableFrom(pjp.getSignature().getDeclaringType()) && pjp.getArgs().length == 2 && pjp.getArgs()[1] instanceof Context;
    }

    public static boolean placedOnStreamHandler(ProceedingJoinPoint pjp) {
        return RequestStreamHandler.class.isAssignableFrom(pjp.getSignature().getDeclaringType()) && pjp.getArgs().length == 3 && pjp.getArgs()[0] instanceof InputStream && pjp.getArgs()[1] instanceof OutputStream && pjp.getArgs()[2] instanceof Context;
    }

    public static Optional<Context> extractContext(ProceedingJoinPoint pjp) {
        if (LambdaHandlerProcessor.isHandlerMethod(pjp)) {
            if (LambdaHandlerProcessor.placedOnRequestHandler(pjp)) {
                return Optional.of((Context)pjp.getArgs()[1]);
            }
            if (LambdaHandlerProcessor.placedOnStreamHandler(pjp)) {
                return Optional.of((Context)pjp.getArgs()[2]);
            }
        }
        return Optional.empty();
    }

    public static String serviceName() {
        return SERVICE_NAME;
    }

    public static boolean isColdStart() {
        return IS_COLD_START == null;
    }

    public static void coldStartDone() {
        IS_COLD_START = false;
    }

    public static boolean isSamLocal() {
        return "true".equals(System.getenv("AWS_SAM_LOCAL"));
    }

    public static Optional<String> getXrayTraceId() {
        String X_AMZN_TRACE_ID = SystemWrapper.getenv("_X_AMZN_TRACE_ID");
        if (X_AMZN_TRACE_ID != null) {
            return Optional.of(X_AMZN_TRACE_ID.split(";")[0].replace("Root=", ""));
        }
        return Optional.empty();
    }
}

