/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.function.BaseFunction;
import software.amazon.lambda.powertools.utilities.JsonConfig;

public class ValidationConfig {
    private SpecVersion.VersionFlag jsonSchemaVersion = SpecVersion.VersionFlag.V7;
    private JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)this.jsonSchemaVersion);

    private ValidationConfig() {
    }

    public static ValidationConfig get() {
        return ConfigHolder.instance;
    }

    public void setSchemaVersion(SpecVersion.VersionFlag version) {
        if (version != this.jsonSchemaVersion) {
            this.jsonSchemaVersion = version;
            this.factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)version);
        }
    }

    public SpecVersion.VersionFlag getSchemaVersion() {
        return this.jsonSchemaVersion;
    }

    public <T extends BaseFunction> void addFunction(T function) {
        JsonConfig.get().addFunction(function);
    }

    public JsonSchemaFactory getFactory() {
        return this.factory;
    }

    public JmesPath<JsonNode> getJmesPath() {
        return JsonConfig.get().getJmesPath();
    }

    public ObjectMapper getObjectMapper() {
        return JsonConfig.get().getObjectMapper();
    }

    /* synthetic */ ValidationConfig(ValidationConfig validationConfig) {
        this();
    }

    private static class ConfigHolder {
        private static final ValidationConfig instance = new ValidationConfig(null);

        private ConfigHolder() {
        }
    }
}

