/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import io.burt.jmespath.Expression;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import software.amazon.lambda.powertools.validation.ValidationConfig;
import software.amazon.lambda.powertools.validation.ValidationException;
import software.amazon.lambda.powertools.validation.internal.ValidationAspect;

public class ValidationUtils {
    private static final String CLASSPATH = "classpath:";
    private static final ConcurrentHashMap<String, JsonSchema> schemas = new ConcurrentHashMap();

    private ValidationUtils() {
    }

    public static void validate(Object obj, String jsonSchema, String envelope) throws ValidationException {
        ValidationUtils.validate(obj, ValidationUtils.getJsonSchema(jsonSchema), envelope);
    }

    public static void validate(Object obj, JsonSchema jsonSchema, String envelope) throws ValidationException {
        JsonNode subNode;
        if (envelope == null || envelope.isEmpty()) {
            ValidationUtils.validate(obj, jsonSchema);
            return;
        }
        try {
            JsonNode jsonNode2 = ValidationConfig.get().getObjectMapper().valueToTree(obj);
            Expression expression = ValidationConfig.get().getJmesPath().compile(envelope);
            subNode = (JsonNode)expression.search((Object)jsonNode2);
        }
        catch (Exception e) {
            throw new ValidationException("Cannot find envelope <" + envelope + "> in the object <" + obj + ">", e);
        }
        if (subNode.getNodeType() == JsonNodeType.ARRAY) {
            subNode.forEach(jsonNode -> ValidationUtils.validate(jsonNode, jsonSchema));
        } else if (subNode.getNodeType() == JsonNodeType.OBJECT) {
            ValidationUtils.validate(subNode, jsonSchema);
        } else if (subNode.getNodeType() == JsonNodeType.STRING) {
            try {
                ValidationUtils.validate(subNode.asText(), jsonSchema);
            }
            catch (ValidationException validationException) {
                throw new ValidationException("Invalid format for '" + envelope + "': 'STRING' and no JSON found in it.");
            }
        } else {
            throw new ValidationException("Invalid format for '" + envelope + "': '" + subNode.getNodeType() + "'");
        }
    }

    public static void validate(Object obj, String jsonSchema) throws ValidationException {
        ValidationUtils.validate(obj, ValidationUtils.getJsonSchema(jsonSchema));
    }

    public static void validate(Object obj, JsonSchema jsonSchema) throws ValidationException {
        JsonNode jsonNode;
        try {
            jsonNode = ValidationConfig.get().getObjectMapper().valueToTree(obj);
        }
        catch (Exception e) {
            throw new ValidationException("Object <" + obj + "> is not valid against the schema provided", e);
        }
        ValidationUtils.validate(jsonNode, jsonSchema);
    }

    public static void validate(String json, String jsonSchema) throws ValidationException {
        ValidationUtils.validate(json, ValidationUtils.getJsonSchema(jsonSchema));
    }

    public static void validate(String json, JsonSchema jsonSchema) throws ValidationException {
        JsonNode jsonNode;
        try {
            jsonNode = ValidationConfig.get().getObjectMapper().readTree(json);
        }
        catch (Exception e) {
            throw new ValidationException("Json <" + json + "> is not valid against the schema provided", e);
        }
        ValidationUtils.validate(jsonNode, jsonSchema);
    }

    public static void validate(Map<String, Object> map, String jsonSchema) throws ValidationException {
        ValidationUtils.validate(map, ValidationUtils.getJsonSchema(jsonSchema));
    }

    public static void validate(Map<String, Object> map, JsonSchema jsonSchema) throws ValidationException {
        JsonNode jsonNode;
        try {
            jsonNode = ValidationConfig.get().getObjectMapper().valueToTree(map);
        }
        catch (Exception e) {
            throw new ValidationException("Map <" + map + "> cannot be converted to json for validation", e);
        }
        ValidationUtils.validate(jsonNode, jsonSchema);
    }

    public static void validate(JsonNode jsonNode, String jsonSchema) throws ValidationException {
        ValidationUtils.validate(jsonNode, ValidationUtils.getJsonSchema(jsonSchema));
    }

    public static void validate(JsonNode jsonNode, JsonSchema jsonSchema) throws ValidationException {
        Set validationMessages = jsonSchema.validate(jsonNode);
        if (!validationMessages.isEmpty()) {
            String message;
            try {
                message = ValidationConfig.get().getObjectMapper().writeValueAsString((Object)new ValidationErrors(validationMessages));
            }
            catch (JsonProcessingException jsonProcessingException) {
                message = validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.joining(", "));
            }
            throw new ValidationException(message);
        }
    }

    public static JsonSchema getJsonSchema(String schema) {
        return ValidationUtils.getJsonSchema(schema, false);
    }

    public static JsonSchema getJsonSchema(String schema, boolean validateSchema) {
        JsonSchema jsonSchema;
        block17: {
            jsonSchema = schemas.get(schema);
            if (jsonSchema != null) {
                return jsonSchema;
            }
            if (schema.startsWith(CLASSPATH)) {
                String filePath = schema.substring(CLASSPATH.length());
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream schemaStream = ValidationAspect.class.getResourceAsStream(filePath);){
                        if (schemaStream == null) {
                            throw new IllegalArgumentException("'" + schema + "' is invalid, verify '" + filePath + "' is in your classpath");
                        }
                        jsonSchema = ValidationConfig.get().getFactory().getSchema(schemaStream);
                        break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("'" + schema + "' is invalid, verify '" + filePath + "' is in your classpath");
                }
            }
            jsonSchema = ValidationConfig.get().getFactory().getSchema(schema);
        }
        if (validateSchema) {
            String version = ValidationConfig.get().getSchemaVersion().toString();
            try {
                ValidationUtils.validate(jsonSchema.getSchemaNode(), ValidationUtils.getJsonSchema("classpath:/schemas/meta_schema_" + version));
            }
            catch (ValidationException ve) {
                throw new IllegalArgumentException("The schema " + schema + " is not valid, it does not respect the specification " + version, ve);
            }
        }
        schemas.put(schema, jsonSchema);
        return jsonSchema;
    }

    public static class ValidationErrors {
        private final Set<ValidationMessage> validationErrors;

        private ValidationErrors(Set<ValidationMessage> validationErrors) {
            this.validationErrors = validationErrors;
        }

        public Set<ValidationMessage> getValidationErrors() {
            return Collections.unmodifiableSet(this.validationErrors);
        }
    }
}

