/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.validation.internal;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2WebSocketResponse;
import com.amazonaws.services.lambda.runtime.events.ActiveMQEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerRequestEvent;
import com.amazonaws.services.lambda.runtime.events.ApplicationLoadBalancerResponseEvent;
import com.amazonaws.services.lambda.runtime.events.CloudFormationCustomResourceEvent;
import com.amazonaws.services.lambda.runtime.events.CloudWatchLogsEvent;
import com.amazonaws.services.lambda.runtime.events.KafkaEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsFirehoseInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsInputPreprocessingResponse;
import com.amazonaws.services.lambda.runtime.events.KinesisAnalyticsStreamsInputPreprocessingEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.lambda.runtime.events.KinesisFirehoseEvent;
import com.amazonaws.services.lambda.runtime.events.RabbitMQEvent;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import com.amazonaws.services.lambda.runtime.events.ScheduledEvent;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.SpecVersion;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import software.amazon.lambda.powertools.core.internal.LambdaHandlerProcessor;
import software.amazon.lambda.powertools.utilities.jmespath.Base64Function;
import software.amazon.lambda.powertools.utilities.jmespath.Base64GZipFunction;
import software.amazon.lambda.powertools.validation.Validation;
import software.amazon.lambda.powertools.validation.ValidationConfig;
import software.amazon.lambda.powertools.validation.ValidationUtils;

@Aspect
public class ValidationAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ValidationAspect ajc$perSingletonInstance;

    @Pointcut(value="@annotation(validation)")
    public /* synthetic */ void callAt(Validation validation) {
    }

    @Around(value="callAt(validation) && execution(@Validation * *.*(..))", argNames="pjp,validation")
    public Object around(ProceedingJoinPoint pjp, Validation validation) throws Throwable {
        Object[] proceedArgs = pjp.getArgs();
        boolean validationNeeded = false;
        if (validation.schemaVersion() != SpecVersion.VersionFlag.V201909) {
            ValidationConfig.get().setSchemaVersion(validation.schemaVersion());
        }
        if (LambdaHandlerProcessor.isHandlerMethod((ProceedingJoinPoint)pjp) && LambdaHandlerProcessor.placedOnRequestHandler((ProceedingJoinPoint)pjp)) {
            validationNeeded = true;
            if (!validation.inboundSchema().isEmpty()) {
                APIGatewayProxyRequestEvent event;
                JsonSchema inboundJsonSchema = ValidationUtils.getJsonSchema(validation.inboundSchema(), true);
                Object obj = pjp.getArgs()[0];
                if (obj instanceof APIGatewayProxyRequestEvent) {
                    event = (APIGatewayProxyRequestEvent)obj;
                    ValidationUtils.validate(event.getBody(), inboundJsonSchema);
                } else if (obj instanceof APIGatewayV2HTTPEvent) {
                    event = (APIGatewayV2HTTPEvent)obj;
                    ValidationUtils.validate(event.getBody(), inboundJsonSchema);
                } else if (obj instanceof SNSEvent) {
                    event = (SNSEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(record.getSNS().getMessage(), inboundJsonSchema));
                } else if (obj instanceof SQSEvent) {
                    event = (SQSEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(record.getBody(), inboundJsonSchema));
                } else if (obj instanceof ScheduledEvent) {
                    event = (ScheduledEvent)obj;
                    ValidationUtils.validate((Map<String, Object>)event.getDetail(), inboundJsonSchema);
                } else if (obj instanceof ApplicationLoadBalancerRequestEvent) {
                    event = (ApplicationLoadBalancerRequestEvent)obj;
                    ValidationUtils.validate(event.getBody(), inboundJsonSchema);
                } else if (obj instanceof CloudWatchLogsEvent) {
                    event = (CloudWatchLogsEvent)obj;
                    ValidationUtils.validate(Base64GZipFunction.decompress((byte[])Base64Function.decode((byte[])event.getAwsLogs().getData().getBytes(StandardCharsets.UTF_8))), inboundJsonSchema);
                } else if (obj instanceof CloudFormationCustomResourceEvent) {
                    event = (CloudFormationCustomResourceEvent)obj;
                    ValidationUtils.validate((Map<String, Object>)event.getResourceProperties(), inboundJsonSchema);
                } else if (obj instanceof KinesisEvent) {
                    event = (KinesisEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getKinesis().getData()), inboundJsonSchema));
                } else if (obj instanceof KinesisFirehoseEvent) {
                    event = (KinesisFirehoseEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getData()), inboundJsonSchema));
                } else if (obj instanceof KafkaEvent) {
                    event = (KafkaEvent)obj;
                    event.getRecords().forEach((s, records) -> records.forEach(record -> ValidationUtils.validate(Base64Function.decode((String)record.getValue()), inboundJsonSchema)));
                } else if (obj instanceof ActiveMQEvent) {
                    event = (ActiveMQEvent)obj;
                    event.getMessages().forEach(record -> ValidationUtils.validate(Base64Function.decode((String)record.getData()), inboundJsonSchema));
                } else if (obj instanceof RabbitMQEvent) {
                    event = (RabbitMQEvent)obj;
                    event.getRmqMessagesByQueue().forEach((s, records) -> records.forEach(record -> ValidationUtils.validate(Base64Function.decode((String)record.getData()), inboundJsonSchema)));
                } else if (obj instanceof KinesisAnalyticsFirehoseInputPreprocessingEvent) {
                    event = (KinesisAnalyticsFirehoseInputPreprocessingEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getData()), inboundJsonSchema));
                } else if (obj instanceof KinesisAnalyticsStreamsInputPreprocessingEvent) {
                    event = (KinesisAnalyticsStreamsInputPreprocessingEvent)obj;
                    event.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getData()), inboundJsonSchema));
                } else {
                    ValidationUtils.validate(obj, inboundJsonSchema, validation.envelope());
                }
            }
        }
        Object result = pjp.proceed(proceedArgs);
        if (validationNeeded && !validation.outboundSchema().isEmpty()) {
            APIGatewayProxyResponseEvent response;
            JsonSchema outboundJsonSchema = ValidationUtils.getJsonSchema(validation.outboundSchema(), true);
            if (result instanceof APIGatewayProxyResponseEvent) {
                response = (APIGatewayProxyResponseEvent)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof APIGatewayV2HTTPResponse) {
                response = (APIGatewayV2HTTPResponse)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof APIGatewayV2WebSocketResponse) {
                response = (APIGatewayV2WebSocketResponse)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof ApplicationLoadBalancerResponseEvent) {
                response = (ApplicationLoadBalancerResponseEvent)result;
                ValidationUtils.validate(response.getBody(), outboundJsonSchema);
            } else if (result instanceof KinesisAnalyticsInputPreprocessingResponse) {
                response = (KinesisAnalyticsInputPreprocessingResponse)result;
                response.getRecords().forEach(record -> ValidationUtils.validate(Base64Function.decode((ByteBuffer)record.getData()), outboundJsonSchema));
            } else {
                ValidationUtils.validate(result, outboundJsonSchema, validation.envelope());
            }
        }
        return result;
    }

    public static ValidationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("software.amazon.lambda.powertools.validation.internal.ValidationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ValidationAspect.ajc$perSingletonInstance = new ValidationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

