/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.openapi.model.ParameterObject;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EncodingObject
extends Component
implements ToSmithyBuilder<EncodingObject> {
    private final Map<String, ParameterObject> headers = new TreeMap<String, ParameterObject>();
    private final String contentType;
    private final String style;
    private final boolean explode;
    private final boolean allowReserved;

    private EncodingObject(Builder builder) {
        super(builder);
        this.headers.putAll(builder.headers);
        this.contentType = builder.contentType;
        this.style = builder.style;
        this.explode = builder.explode;
        this.allowReserved = builder.allowReserved;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, ParameterObject> getHeaders() {
        return this.headers;
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    public Optional<String> getStyle() {
        return Optional.ofNullable(this.style);
    }

    public boolean isExplode() {
        return this.explode;
    }

    public boolean isAllowReserved() {
        return this.allowReserved;
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().withOptionalMember("contentType", this.getContentType().map(Node::from)).withOptionalMember("style", this.getStyle().map(Node::from));
        if (!this.headers.isEmpty()) {
            builder.withMember("headers", (ToNode)this.headers.entrySet().stream().collect(ObjectNode.collectStringKeys(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (this.allowReserved) {
            builder.withMember("allowReserved", (ToNode)Node.from((boolean)true));
        }
        if (this.explode) {
            builder.withMember("explode", (ToNode)Node.from((boolean)true));
        }
        return builder;
    }

    public Builder toBuilder() {
        return ((Builder)EncodingObject.builder().extensions(this.getExtensions())).headers(this.headers).contentType(this.contentType).style(this.style).explode(this.explode).allowReserved(this.allowReserved);
    }

    public static final class Builder
    extends Component.Builder<Builder, EncodingObject> {
        private final Map<String, ParameterObject> headers = new TreeMap<String, ParameterObject>();
        private String contentType;
        private String style;
        private boolean explode;
        private boolean allowReserved;

        private Builder() {
        }

        public EncodingObject build() {
            return new EncodingObject(this);
        }

        public Builder headers(Map<String, ParameterObject> headers) {
            this.headers.clear();
            this.headers.putAll(headers);
            return this;
        }

        public Builder putHeader(String name, ParameterObject header) {
            this.headers.put(name, header);
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            return this;
        }

        public Builder explode(boolean explode) {
            this.explode = explode;
            return this;
        }

        public Builder allowReserved(boolean allowReserved) {
            this.allowReserved = allowReserved;
            return this;
        }
    }
}

