/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.model;

import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.openapi.model.Component;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ExternalDocumentation
extends Component
implements ToSmithyBuilder<ExternalDocumentation> {
    private final String description;
    private final String url;

    private ExternalDocumentation(Builder builder) {
        super(builder);
        this.url = (String)SmithyBuilder.requiredState((String)"url", (Object)builder.url);
        this.description = builder.description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public String getUrl() {
        return this.url;
    }

    public Builder toBuilder() {
        return ((Builder)ExternalDocumentation.builder().extensions(this.getExtensions())).description(this.description).url(this.url);
    }

    @Override
    protected ObjectNode.Builder createNodeBuilder() {
        return Node.objectNodeBuilder().withOptionalMember("description", this.getDescription().map(Node::from)).withMember("url", this.url);
    }

    public static final class Builder
    extends Component.Builder<Builder, ExternalDocumentation> {
        private String description;
        private String url;

        private Builder() {
        }

        public ExternalDocumentation build() {
            return new ExternalDocumentation(this);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }
}

