/*
 * Decompiled with CFR 0.152.
 */
package software.aws.toolkits.telemetry.generator;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Suppress;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.aws.toolkits.telemetry.generator.MetadataSchema;
import software.aws.toolkits.telemetry.generator.MetricSchema;
import software.aws.toolkits.telemetry.generator.MetricUnit;
import software.aws.toolkits.telemetry.generator.ResourceLoader;
import software.aws.toolkits.telemetry.generator.TelemetryGeneratorKt;
import software.aws.toolkits.telemetry.generator.TelemetryMetricType;
import software.aws.toolkits.telemetry.generator.TelemetryParser;
import software.aws.toolkits.telemetry.generator.TelemetryParserKt;
import software.aws.toolkits.telemetry.generator.TelemetrySchema;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a,\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00162\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\"\u001a\u00020 \u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0001\u001a\u001c\u0010$\u001a\u00020%*\u00020%2\u0006\u0010&\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010'\u001a\u00020(*\u00020(H\u0002\u001a\u0014\u0010)\u001a\u00020%*\u00020%2\u0006\u0010*\u001a\u00020+H\u0002\u001a\"\u0010,\u001a\u00020(*\u00020(2\u0006\u0010-\u001a\u00020\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002\u001a\u0014\u0010/\u001a\u00020\u001e*\u0002002\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\"\u00101\u001a\u00020%*\u00020%2\u0006\u0010\u0011\u001a\u00020\u00012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u001a\u0014\u00103\u001a\u00020(*\u00020(2\u0006\u00104\u001a\u000205H\u0002\u001a\u001a\u00106\u001a\u00020(*\u00020(2\f\u00107\u001a\b\u0012\u0004\u0012\u0002050\u0016H\u0002\u001a\u001a\u00108\u001a\u00020(*\u00020(2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002\u001a\f\u0010:\u001a\u00020\u0017*\u00020+H\u0002\u001a\n\u0010;\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010<\u001a\u00020\u0001*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0005\u00a8\u0006="}, d2={"JETBRAINS_TELEMETRY_PACKAGE_NAME", "", "METRIC_METADATA", "Lcom/squareup/kotlinpoet/ClassName;", "getMETRIC_METADATA", "()Lcom/squareup/kotlinpoet/ClassName;", "PACKAGE_NAME", "PROJECT", "Lcom/squareup/kotlinpoet/TypeName;", "getPROJECT", "()Lcom/squareup/kotlinpoet/TypeName;", "RESULT", "SUCCESS", "TELEMETRY_SERVICE", "getTELEMETRY_SERVICE", "buildMetricMetadataFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "functionName", "metric", "Lsoftware/aws/toolkits/telemetry/generator/MetricSchema;", "buildMetricMetadataOverloadFunction", "buildMetricParameters", "", "Lcom/squareup/kotlinpoet/ParameterSpec;", "buildProjectFunction", "buildProjectOverloadFunction", "buildRecordFunction", "metadataProvider", "buildResultOverloadFunction", "generateTelemetryFromFiles", "", "inputFiles", "Ljava/io/File;", "defaultDefinitions", "outputFolder", "filterInvalidCharacters", "generateFunctionBody", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "metadataParameter", "generateHeader", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "generateMetadataStatement", "data", "Lsoftware/aws/toolkits/telemetry/generator/MetadataSchema;", "generateNamespaces", "namespace", "metrics", "generateRecordFunctions", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "generateResultOverloadFunctionBody", "parameters", "generateTelemetryEnumType", "item", "Lsoftware/aws/toolkits/telemetry/generator/TelemetryMetricType;", "generateTelemetryEnumTypes", "items", "generateTelemetryObjects", "schema", "metadataToParameter", "toArgumentFormat", "toTypeFormat", "telemetry-generator"})
public final class TelemetryGeneratorKt {
    @NotNull
    public static final String PACKAGE_NAME = "software.aws.toolkits.telemetry";
    @NotNull
    public static final String JETBRAINS_TELEMETRY_PACKAGE_NAME = "software.aws.toolkits.jetbrains.services.telemetry";
    @NotNull
    private static final ClassName METRIC_METADATA = new ClassName("software.aws.toolkits.jetbrains.services.telemetry", new String[]{"MetricEventMetadata"});
    @NotNull
    private static final ClassName TELEMETRY_SERVICE = new ClassName("software.aws.toolkits.jetbrains.services.telemetry", new String[]{"TelemetryService"});
    @NotNull
    private static final TypeName PROJECT = TypeName.copy$default((TypeName)new ClassName("com.intellij.openapi.project", new String[]{"Project"}), (boolean)true, null, (int)2, null);
    @NotNull
    public static final String RESULT = "result";
    @NotNull
    public static final String SUCCESS = "success";

    @NotNull
    public static final ClassName getMETRIC_METADATA() {
        return METRIC_METADATA;
    }

    @NotNull
    public static final ClassName getTELEMETRY_SERVICE() {
        return TELEMETRY_SERVICE;
    }

    @NotNull
    public static final TypeName getPROJECT() {
        return PROJECT;
    }

    @NotNull
    public static final String filterInvalidCharacters(@NotNull String $this$filterInvalidCharacters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$filterInvalidCharacters, (String)"$this$filterInvalidCharacters");
        return StringsKt.replace$default((String)$this$filterInvalidCharacters, (String)".", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toTypeFormat(@NotNull String $this$toTypeFormat) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toTypeFormat, (String)"$this$toTypeFormat");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)TelemetryGeneratorKt.filterInvalidCharacters($this$toTypeFormat), (String[])new String[]{"_", "-"}, (boolean)false, (int)0, (int)6, null), (CharSequence)"", null, null, (int)0, null, (Function1)toTypeFormat.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String toArgumentFormat(@NotNull String $this$toArgumentFormat) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toArgumentFormat, (String)"$this$toArgumentFormat");
        return StringsKt.decapitalize((String)TelemetryGeneratorKt.toTypeFormat($this$toArgumentFormat));
    }

    public static final void generateTelemetryFromFiles(@NotNull List<? extends File> inputFiles, @NotNull List<String> defaultDefinitions, @NotNull File outputFolder) {
        Intrinsics.checkParameterIsNotNull(inputFiles, (String)"inputFiles");
        Intrinsics.checkParameterIsNotNull(defaultDefinitions, (String)"defaultDefinitions");
        Intrinsics.checkParameterIsNotNull((Object)outputFolder, (String)"outputFolder");
        TelemetrySchema telemetry = TelemetryParser.INSTANCE.parseFiles(inputFiles, defaultDefinitions);
        outputFolder.mkdirs();
        TelemetryGeneratorKt.generateTelemetryObjects(TelemetryGeneratorKt.generateTelemetryEnumTypes(TelemetryGeneratorKt.generateHeader(FileSpec.Companion.builder(PACKAGE_NAME, "TelemetryDefinitions").indent(StringsKt.repeat((CharSequence)" ", (int)4))), telemetry.getTypes()), telemetry.getMetrics()).build().writeTo(outputFolder);
    }

    public static /* synthetic */ void generateTelemetryFromFiles$default(List list, List list2, File file, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = ResourceLoader.INSTANCE.getDEFINITIONS_FILES();
        }
        TelemetryGeneratorKt.generateTelemetryFromFiles(list, list2, file);
    }

    private static final FileSpec.Builder generateHeader(@NotNull FileSpec.Builder $this$generateHeader) {
        $this$generateHeader.addComment("Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n", new Object[0]);
        $this$generateHeader.addComment("SPDX-License-Identifier: Apache-2.0\n", new Object[0]);
        $this$generateHeader.addComment("THIS FILE IS GENERATED! DO NOT EDIT BY HAND!", new Object[0]);
        $this$generateHeader.addAnnotation(AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Suppress.class)).addMember("\"unused\", \"MemberVisibilityCanBePrivate\"", new Object[0]).build());
        return $this$generateHeader;
    }

    private static final FileSpec.Builder generateTelemetryEnumTypes(@NotNull FileSpec.Builder $this$generateTelemetryEnumTypes, List<TelemetryMetricType> items) {
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TelemetryMetricType it = (TelemetryMetricType)element$iv;
            boolean bl = false;
            if (it.getAllowedValues() == null) continue;
            TelemetryGeneratorKt.generateTelemetryEnumType($this$generateTelemetryEnumTypes, it);
        }
        return $this$generateTelemetryEnumTypes;
    }

    private static final FileSpec.Builder generateTelemetryEnumType(@NotNull FileSpec.Builder $this$generateTelemetryEnumType, TelemetryMetricType item) {
        TypeSpec.Builder builder = TypeSpec.Companion.enumBuilder(TelemetryGeneratorKt.toTypeFormat(item.getName())).primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter("value", Reflection.getOrCreateKotlinClass(String.class), new KModifier[]{KModifier.PRIVATE}).build()).addProperty(PropertySpec.Companion.builder("value", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).initializer("value", new Object[0]).build()).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("toString").addModifiers(new KModifier[]{KModifier.OVERRIDE}), (KClass)Reflection.getOrCreateKotlinClass(String.class), null, (int)2, null).addStatement("return value", new Object[0]).build()).addKdoc(item.getDescription(), new Object[0]);
        List<Object> list = item.getAllowedValues();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object enumValue = element$iv = iterator.next();
            boolean bl = false;
            builder.addEnumConstant(TelemetryGeneratorKt.toTypeFormat(enumValue.toString()), TypeSpec.Companion.anonymousClassBuilder().addSuperclassConstructorParameter("%S", new Object[]{enumValue.toString()}).build());
        }
        String unknownType = TelemetryGeneratorKt.toTypeFormat("unknown");
        builder.addEnumConstant(unknownType, TypeSpec.Companion.anonymousClassBuilder().addSuperclassConstructorParameter("%S", new Object[]{"unknown"}).build()).build();
        TypeSpec companion = TypeSpec.Companion.companionObjectBuilder$default((TypeSpec.Companion)TypeSpec.Companion, null, (int)1, null).addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("from"), (TypeName)((TypeName)new ClassName("", new String[]{TelemetryGeneratorKt.toTypeFormat(item.getName())})), null, (int)2, null).addParameter("type", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addStatement("return values().firstOrNull { it.value == type } ?: " + unknownType, new Object[0]).build()).build();
        builder.addType(companion);
        $this$generateTelemetryEnumType.addType(builder.build());
        return $this$generateTelemetryEnumType;
    }

    /*
     * WARNING - void declaration
     */
    private static final FileSpec.Builder generateTelemetryObjects(@NotNull FileSpec.Builder $this$generateTelemetryObjects, List<MetricSchema> schema) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = schema;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MetricSchema it = (MetricSchema)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = TelemetryParserKt.namespace(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = MapsKt.toSortedMap((Map)destination$iv$iv);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$namespace$metrics = element$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry entry = $dstr$namespace$metrics;
            boolean bl4 = false;
            String namespace = (String)entry.getKey();
            entry = $dstr$namespace$metrics;
            bl4 = false;
            List metrics = (List)entry.getValue();
            String string = namespace;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"namespace");
            List list = metrics;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"metrics");
            TelemetryGeneratorKt.generateNamespaces($this$generateTelemetryObjects, string, list);
        }
        return $this$generateTelemetryObjects;
    }

    private static final FileSpec.Builder generateNamespaces(@NotNull FileSpec.Builder $this$generateNamespaces, String namespace, List<MetricSchema> metrics) {
        TypeSpec.Builder telemetryObject = TypeSpec.Companion.objectBuilder(TelemetryGeneratorKt.toTypeFormat(namespace) + "Telemetry");
        Iterable $this$sortedBy$iv = metrics;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                MetricSchema it = (MetricSchema)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (MetricSchema)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetricSchema it = (MetricSchema)element$iv;
            boolean bl2 = false;
            TelemetryGeneratorKt.generateRecordFunctions(telemetryObject, it);
        }
        $this$generateNamespaces.addType(telemetryObject.build());
        return $this$generateNamespaces;
    }

    private static final void generateRecordFunctions(@NotNull TypeSpec.Builder $this$generateRecordFunctions, MetricSchema metric) {
        boolean bl;
        String functionName;
        block4: {
            functionName = (String)StringsKt.split$default((CharSequence)metric.getName(), (String[])new String[]{"_"}, (boolean)false, (int)0, (int)6, null).get(1);
            $this$generateRecordFunctions.addFunction(TelemetryGeneratorKt.buildProjectFunction(functionName, metric));
            $this$generateRecordFunctions.addFunction(TelemetryGeneratorKt.buildMetricMetadataFunction(functionName, metric));
            Iterable $this$none$iv = metric.getMetadata();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    MetadataSchema it = (MetadataSchema)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)RESULT)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        $this$generateRecordFunctions.addFunction(TelemetryGeneratorKt.buildProjectOverloadFunction(functionName, metric));
        $this$generateRecordFunctions.addFunction(TelemetryGeneratorKt.buildMetricMetadataOverloadFunction(functionName, metric));
    }

    @NotNull
    public static final FunSpec buildProjectFunction(@NotNull String functionName, @NotNull MetricSchema metric) {
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        ParameterSpec metadataProvider = ParameterSpec.Companion.builder("project", PROJECT, new KModifier[0]).defaultValue("null", new Object[0]).build();
        return TelemetryGeneratorKt.buildRecordFunction(metadataProvider, functionName, metric);
    }

    @NotNull
    public static final FunSpec buildMetricMetadataFunction(@NotNull String functionName, @NotNull MetricSchema metric) {
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        ParameterSpec metadataProvider = ParameterSpec.Companion.builder("metadata", (TypeName)METRIC_METADATA, new KModifier[0]).build();
        return TelemetryGeneratorKt.buildRecordFunction(metadataProvider, functionName, metric);
    }

    private static final FunSpec buildRecordFunction(ParameterSpec metadataProvider, String functionName, MetricSchema metric) {
        boolean bl = false;
        List functionParameters = new ArrayList();
        functionParameters.add(metadataProvider);
        functionParameters.addAll((Collection)TelemetryGeneratorKt.buildMetricParameters(metric));
        return TelemetryGeneratorKt.generateFunctionBody(FunSpec.Companion.builder(functionName).addKdoc(metric.getDescription(), new Object[0]).addParameters((Iterable)functionParameters), metadataProvider, metric).build();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ParameterSpec> buildMetricParameters(MetricSchema metric) {
        Collection<ParameterSpec> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean bl = false;
        List list = new ArrayList();
        Iterable iterable = metric.getMetadata();
        List list2 = list;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MetadataSchema metadataSchema = (MetadataSchema)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            ParameterSpec parameterSpec = TelemetryGeneratorKt.metadataToParameter((MetadataSchema)it);
            collection.add(parameterSpec);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        list.add(ParameterSpec.Companion.builder("value", (TypeName)TypeNames.DOUBLE, new KModifier[0]).defaultValue("1.0", new Object[0]).build());
        list.add(ParameterSpec.Companion.builder("createTime", Reflection.getOrCreateKotlinClass(Instant.class), new KModifier[0]).defaultValue("Instant.now()", new Object[0]).build());
        return list;
    }

    private static final ParameterSpec metadataToParameter(@NotNull MetadataSchema $this$metadataToParameter) {
        TypeName typeName = TypeName.copy$default((TypeName)($this$metadataToParameter.getType().getAllowedValues() != null ? (TypeName)new ClassName(PACKAGE_NAME, new String[]{TelemetryGeneratorKt.toTypeFormat($this$metadataToParameter.getType().getName())}) : $this$metadataToParameter.getType().getType().kotlinType()), (boolean)Intrinsics.areEqual((Object)$this$metadataToParameter.getRequired(), (Object)false), null, (int)2, null);
        ParameterSpec.Builder parameterSpec = ParameterSpec.Companion.builder(TelemetryGeneratorKt.toArgumentFormat($this$metadataToParameter.getType().getName()), typeName, new KModifier[0]);
        if (Intrinsics.areEqual((Object)$this$metadataToParameter.getRequired(), (Object)false)) {
            parameterSpec.defaultValue("null", new Object[0]);
        }
        return parameterSpec.build();
    }

    private static final FunSpec.Builder generateFunctionBody(@NotNull FunSpec.Builder $this$generateFunctionBody, ParameterSpec metadataParameter, MetricSchema metric) {
        MemberName metricUnit = new MemberName("software.amazon.awssdk.services.toolkittelemetry.model", "Unit");
        $this$generateFunctionBody.beginControlFlow("%T.getInstance().record(" + metadataParameter.getName() + ')', new Object[]{TELEMETRY_SERVICE});
        $this$generateFunctionBody.beginControlFlow("datum(%S)", new Object[]{metric.getName()});
        $this$generateFunctionBody.addStatement("createTime(createTime)", new Object[0]);
        StringBuilder stringBuilder = new StringBuilder().append("unit(%M.");
        MetricUnit metricUnit2 = metric.getUnit();
        if (metricUnit2 == null) {
            metricUnit2 = MetricUnit.NONE;
        }
        $this$generateFunctionBody.addStatement(stringBuilder.append(metricUnit2.name()).append(')').toString(), new Object[]{metricUnit});
        $this$generateFunctionBody.addStatement("value(value)", new Object[0]);
        $this$generateFunctionBody.addStatement("passive(" + metric.getPassive() + ')', new Object[0]);
        Iterable $this$forEach$iv = metric.getMetadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataSchema it = (MetadataSchema)element$iv;
            boolean bl = false;
            TelemetryGeneratorKt.generateMetadataStatement($this$generateFunctionBody, it);
        }
        $this$generateFunctionBody.endControlFlow();
        $this$generateFunctionBody.endControlFlow();
        return $this$generateFunctionBody;
    }

    @NotNull
    public static final FunSpec buildProjectOverloadFunction(@NotNull String functionName, @NotNull MetricSchema metric) {
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        ParameterSpec metadataProvider = ParameterSpec.Companion.builder("project", PROJECT, new KModifier[0]).defaultValue("null", new Object[0]).build();
        return TelemetryGeneratorKt.buildResultOverloadFunction(metadataProvider, functionName, metric);
    }

    @NotNull
    public static final FunSpec buildMetricMetadataOverloadFunction(@NotNull String functionName, @NotNull MetricSchema metric) {
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        ParameterSpec metadataProvider = ParameterSpec.Companion.builder("metadata", (TypeName)METRIC_METADATA, new KModifier[0]).build();
        return TelemetryGeneratorKt.buildResultOverloadFunction(metadataProvider, functionName, metric);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunSpec buildResultOverloadFunction(@NotNull ParameterSpec metadataProvider, @NotNull String functionName, @NotNull MetricSchema metric) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)metadataProvider, (String)"metadataProvider");
        Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        Iterable $this$map$iv = TelemetryGeneratorKt.buildMetricParameters(metric);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParameterSpec parameterSpec = (ParameterSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_13 = Intrinsics.areEqual((Object)it.getName(), (Object)RESULT) ? ParameterSpec.Companion.builder(SUCCESS, (TypeName)TypeNames.BOOLEAN, new KModifier[0]).build() : it;
            collection.add(var14_13);
        }
        List overloadedParameters = (List)destination$iv$iv;
        boolean bl = false;
        List functionParameters = new ArrayList();
        functionParameters.add(metadataProvider);
        functionParameters.addAll(overloadedParameters);
        return TelemetryGeneratorKt.generateResultOverloadFunctionBody(FunSpec.Companion.builder(functionName).addKdoc(metric.getDescription(), new Object[0]).addParameters((Iterable)functionParameters), functionName, functionParameters).build();
    }

    private static final FunSpec.Builder generateResultOverloadFunctionBody(@NotNull FunSpec.Builder $this$generateResultOverloadFunctionBody, String functionName, List<ParameterSpec> parameters) {
        $this$generateResultOverloadFunctionBody.addStatement("%L(%L)", new Object[]{functionName, CollectionsKt.joinToString$default((Iterable)parameters, null, null, null, (int)0, null, (Function1)generateResultOverloadFunctionBody.1.INSTANCE, (int)31, null)});
        return $this$generateResultOverloadFunctionBody;
    }

    /*
     * Unable to fully structure code
     */
    private static final FunSpec.Builder generateMetadataStatement(@NotNull FunSpec.Builder $this$generateMetadataStatement, MetadataSchema data) {
        if (Intrinsics.areEqual((Object)data.getRequired(), (Object)false)) {
            $this$generateMetadataStatement.beginControlFlow("if(%L != null) {", new Object[]{TelemetryGeneratorKt.toArgumentFormat(data.getType().getName())});
        }
        if (Intrinsics.areEqual((Object)data.getType().getType().kotlinType(), (Object)TypeNames.STRING) ^ true) ** GOTO lbl-1000
        v0 = data.getType().getAllowedValues();
        if (v0 != null) {
            var3_2 = v0;
            var4_3 = false;
            ** if (!(var3_2.isEmpty() == false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = TelemetryGeneratorKt.toArgumentFormat(data.getType().getName()) + ".toString()";
            ** GOTO lbl14
        }
lbl-1000:
        // 2 sources

        {
            v1 = TelemetryGeneratorKt.toArgumentFormat(data.getType().getName());
        }
lbl14:
        // 2 sources

        setStatement = v1;
        $this$generateMetadataStatement.addStatement("metadata(%S, %L)", new Object[]{TelemetryGeneratorKt.toArgumentFormat(data.getType().getName()), setStatement});
        if (Intrinsics.areEqual((Object)data.getRequired(), (Object)false)) {
            $this$generateMetadataStatement.endControlFlow();
        }
        return $this$generateMetadataStatement;
    }
}

