/*
 * Decompiled with CFR 0.152.
 */
package software.aws.toolkits.telemetry.generator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.json.JSONTokener;
import software.aws.toolkits.telemetry.generator.MetadataDefinition;
import software.aws.toolkits.telemetry.generator.MetadataSchema;
import software.aws.toolkits.telemetry.generator.MetricDefinition;
import software.aws.toolkits.telemetry.generator.MetricSchema;
import software.aws.toolkits.telemetry.generator.MetricUnit;
import software.aws.toolkits.telemetry.generator.ResourceLoader;
import software.aws.toolkits.telemetry.generator.TelemetryDefinition;
import software.aws.toolkits.telemetry.generator.TelemetryMetricType;
import software.aws.toolkits.telemetry.generator.TelemetrySchema;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lsoftware/aws/toolkits/telemetry/generator/TelemetryParser;", "", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "parse", "Lsoftware/aws/toolkits/telemetry/generator/TelemetryDefinition;", "input", "", "parseFiles", "Lsoftware/aws/toolkits/telemetry/generator/TelemetrySchema;", "paths", "", "Ljava/io/File;", "defaultResourcesFiles", "validate", "", "fileContents", "schema", "Lorg/everit/json/schema/Schema;", "telemetry-generator"})
public final class TelemetryParser {
    private static final ObjectMapper MAPPER;
    public static final TelemetryParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TelemetrySchema parseFiles(@NotNull List<? extends File> paths, @NotNull List<String> defaultResourcesFiles) {
        void $this$mapTo$iv$iv;
        MetricDefinition it;
        Iterable $this$associateByTo$iv$iv;
        void $this$fold$iv;
        List list;
        TelemetryDefinition it2;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        Intrinsics.checkParameterIsNotNull(defaultResourcesFiles, (String)"defaultResourcesFiles");
        Iterable $this$map$iv = paths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it3;
            File file = (File)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = FilesKt.readText$default((File)it3, null, (int)1, null);
            object2.add(object);
        }
        List files = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)defaultResourcesFiles);
        JSONObject rawSchema = new JSONObject(new JSONTokener(ResourceLoader.INSTANCE.getSCHEMA_FILE()));
        Schema schema = SchemaLoader.load((JSONObject)rawSchema);
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"SchemaLoader.load(rawSchema)");
        Schema schema2 = schema;
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it4 = (String)element$iv2;
            boolean bl = false;
            INSTANCE.validate(it4, schema2);
        }
        Iterable $this$map$iv2 = files;
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator iterator = (String)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object = INSTANCE.parse((String)((Object)it2));
            object2.add(object);
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        List list2 = CollectionsKt.emptyList();
        $i$f$map2 = false;
        List list3 = list = CollectionsKt.emptyList();
        List list4 = list2;
        TelemetryDefinition initial$iv = new TelemetryDefinition(list4, list3);
        boolean $i$f$fold = false;
        TelemetryDefinition accumulator$iv = initial$iv;
        for (Object element$iv3 : $this$fold$iv) {
            void it22;
            Object item$iv$iv;
            item$iv$iv = (TelemetryDefinition)element$iv3;
            it2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new TelemetryDefinition(CollectionsKt.plus((Collection)it2.getTypes(), (Iterable)it22.getTypes()), CollectionsKt.plus((Collection)it2.getMetrics(), (Iterable)it22.getMetrics()));
        }
        TelemetryDefinition telemetryDefinition = accumulator$iv;
        Iterable $this$associateBy$iv = telemetryDefinition.getTypes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapTo22 = $this$associateBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            TelemetryMetricType telemetryMetricType = (TelemetryMetricType)element$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object = ((TelemetryMetricType)((Object)it)).getName();
            object2.put(object, element$iv$iv);
        }
        Map metadataTypes = destination$iv$iv3;
        Iterable $this$map$iv3 = telemetryDefinition.getMetrics();
        boolean $i$f$map3 = false;
        $this$associateByTo$iv$iv = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<MetadataSchema> collection;
            void $this$mapTo$iv$iv4;
            void $this$map$iv4;
            it = (MetricDefinition)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            Iterable iterable2 = it.getMetadata();
            MetricUnit metricUnit = it.getUnit();
            String string = it.getDescription();
            String string2 = it.getName();
            boolean $i$f$map4 = false;
            void var25_45 = $this$map$iv4;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                void metadata;
                MetadataDefinition metadataDefinition = (MetadataDefinition)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl2 = false;
                MetadataSchema metadataSchema = new MetadataSchema((TelemetryMetricType)MapsKt.getValue((Map)metadataTypes, (Object)metadata.getType()), metadata.getRequired());
                collection.add(metadataSchema);
            }
            collection = (List)destination$iv$iv4;
            boolean bl3 = it.getPassive();
            List list5 = collection;
            MetricUnit metricUnit2 = metricUnit;
            String string3 = string;
            String string4 = string2;
            object = new MetricSchema(string4, string3, metricUnit2, list5, bl3);
            object2.add(object);
        }
        List resolvedMetricTypes = (List)destination$iv$iv3;
        return new TelemetrySchema(telemetryDefinition.getTypes(), resolvedMetricTypes);
    }

    public static /* synthetic */ TelemetrySchema parseFiles$default(TelemetryParser telemetryParser, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return telemetryParser.parseFiles(list, list2);
    }

    private final void validate(String fileContents, Schema schema) {
        try {
            schema.validate((Object)new JSONObject(fileContents));
        }
        catch (Exception e) {
            System.err.println("Schema validation failed due to thrown exception " + e + "\non input:\n" + fileContents);
            throw (Throwable)e;
        }
    }

    private final TelemetryDefinition parse(String input) {
        TelemetryDefinition telemetryDefinition;
        try {
            ObjectMapper $this$readValue$iv = MAPPER;
            boolean $i$f$readValue = false;
            String string = input;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<TelemetryDefinition>(){};
            telemetryDefinition = (TelemetryDefinition)objectMapper.readValue(string, typeReference);
        }
        catch (Exception e) {
            System.err.println("Error while parsing: " + e);
            throw (Throwable)e;
        }
        return telemetryDefinition;
    }

    private TelemetryParser() {
    }

    static {
        TelemetryParser telemetryParser;
        INSTANCE = telemetryParser = new TelemetryParser();
        MAPPER = ExtensionsKt.jacksonObjectMapper();
    }
}

