package momento.sdk.responses.cache;

import momento.sdk.exceptions.SdkException;

/** Response for a cache delete operation */
public interface DeleteResponse {

  /** A successful cache delete operation. */
  class Success implements DeleteResponse {}

  /**
   * A failed cache delete operation. The response itself is an exception, so it can be directly
   * thrown, or the cause of the error can be retrieved with {@link #getCause()}. The message is a
   * copy of the message of the cause.
   */
  class Error extends SdkException implements DeleteResponse {

    /**
     * Constructs a cache delete error with a cause.
     *
     * @param cause the cause.
     */
    public Error(SdkException cause) {
      super(cause);
    }
  }
}
