/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.dynamodb.validation;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.tnb.common.service.Validation;
import software.tnb.common.utils.WaitUtils;

public class DynamoDBValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDBValidation.class);
    private static final String TABLE_NAME_PATTERN = "[a-zA-Z0-9.\\-_]{3,255}";
    private final DynamoDbClient client;
    private final DynamoDbStreamsClient streamsClient;

    public DynamoDBValidation(DynamoDbClient client, DynamoDbStreamsClient streamsClient) {
        this.client = client;
        this.streamsClient = streamsClient;
    }

    public void deleteTable(String tableName) {
        LOG.info("Deleting DynamoDB table {}", (Object)tableName);
        ListTablesResponse listTables = this.client.listTables((ListTablesRequest)ListTablesRequest.builder().build());
        if (listTables.tableNames().contains(tableName)) {
            this.client.deleteTable(b -> b.tableName(tableName));
        } else {
            LOG.debug("The DynamoDB table {} doesn't exist", (Object)tableName);
        }
    }

    public void createTable(String tableName, String primaryKey) {
        LOG.info("Creating DynamoDB table {}", (Object)tableName);
        if (!tableName.matches(TABLE_NAME_PATTERN)) {
            throw new IllegalArgumentException("Table name must be between 3 and 255 characters, containing only letters, numbers, underscores (_), hyphens (-), and periods (.)");
        }
        this.client.createTable(b -> b.tableName(tableName).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(5L)).writeCapacityUnits(Long.valueOf(5L)).build()).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(primaryKey).keyType(KeyType.HASH).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeType(ScalarAttributeType.S).attributeName(primaryKey).build()}));
        WaitUtils.waitFor(() -> "active".equalsIgnoreCase(this.client.describeTable(b -> b.tableName(tableName)).table().tableStatusAsString()), (int)6, (long)5000L, (String)("Waiting until the DynamoDB table " + tableName + " is created"));
    }

    public String enableDataStream(String tableName) {
        this.client.updateTable(b -> b.tableName(tableName).streamSpecification(s -> s.streamEnabled(Boolean.valueOf(true)).streamViewType(StreamViewType.NEW_IMAGE)));
        String streamArn = this.client.describeTable(b -> b.tableName(tableName)).table().latestStreamArn();
        WaitUtils.waitFor(() -> "enabled".equalsIgnoreCase(this.streamsClient.describeStream(b -> b.streamArn(streamArn)).streamDescription().streamStatusAsString()), (int)6, (long)5000L, (String)("Waiting until the stream for DynamoDB table " + tableName + " is enabled"));
        return streamArn;
    }

    public void insert(String tableName, Map<String, String> record) {
        Map<String, AttributeValue> input = record.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (AttributeValue)AttributeValue.builder().s((String)entry.getValue()).build()));
        this.client.putItem((PutItemRequest)PutItemRequest.builder().item(input).tableName(tableName).build());
        LOG.debug("Created item {} in table {}", record, (Object)tableName);
    }

    public Map<String, String> getItem(String tableName, String key, String keyVal) {
        Map<String, AttributeValue> keyToGet = Collections.singletonMap(key, (AttributeValue)AttributeValue.builder().s(keyVal).build());
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().key(keyToGet).tableName(tableName).build();
        Map<String, String> returnedItem = this.client.getItem(request).item().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AttributeValue)entry.getValue()).s()));
        return returnedItem;
    }
}

