/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.redshift.service;

import com.google.auto.service.AutoService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.Snapshot;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.tnb.aws.common.account.AWSAccount;
import software.tnb.aws.common.client.AWSClient;
import software.tnb.aws.common.service.AWSService;
import software.tnb.aws.redshift.account.RedshiftAccount;
import software.tnb.aws.redshift.validation.RedshiftValidation;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.utils.WaitUtils;

@AutoService(value={Redshift.class})
public class Redshift
extends AWSService<RedshiftAccount, RedshiftDataClient, RedshiftValidation> {
    private RedshiftClient redshiftClient;

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new AWS Redshift validation");
        this.redshiftClient = (RedshiftClient)AWSClient.createDefaultClient((AWSAccount)this.account(), RedshiftClient.class);
        this.validation = new RedshiftValidation(this.redshiftClient, (RedshiftDataClient)this.client(RedshiftDataClient.class), this.account());
        LOG.debug("Clusters: " + this.redshiftClient.describeClusters().toString());
        this.resumeCluster();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.afterAll(extensionContext);
        this.pauseCluster();
        if (this.redshiftClient != null) {
            this.redshiftClient.close();
        }
    }

    public RedshiftAccount account() {
        if (this.account == null) {
            this.account = (AWSAccount)AccountFactory.create(RedshiftAccount.class);
        }
        return (RedshiftAccount)this.account;
    }

    public Cluster getCluster() {
        return this.redshiftClient.describeClusters().clusters().stream().filter(cluster -> cluster.clusterIdentifier().equals(((RedshiftAccount)this.account).clusterIdentifier())).findFirst().get();
    }

    private void resumeCluster() {
        if (!this.getCluster().clusterAvailabilityStatus().equalsIgnoreCase("available")) {
            this.redshiftClient.resumeCluster(builder -> builder.clusterIdentifier(((RedshiftAccount)this.account).clusterIdentifier()).build());
            WaitUtils.waitFor(() -> this.getCluster().clusterAvailabilityStatus().equalsIgnoreCase("available"), (int)30, (long)30000L, (String)("Waiting for Cluster " + this.getCluster().clusterIdentifier() + " to be available"));
        }
    }

    private void pauseCluster() {
        if (!this.getCluster().clusterAvailabilityStatus().equalsIgnoreCase("paused")) {
            this.checkSnapshots();
            try {
                this.redshiftClient.pauseCluster(builder -> builder.clusterIdentifier(((RedshiftAccount)this.account).clusterIdentifier()).build());
                WaitUtils.waitFor(() -> this.getCluster().clusterAvailabilityStatus().equalsIgnoreCase("paused"), (int)30, (long)30000L, (String)("Waiting for Cluster " + this.getCluster().clusterIdentifier() + " to be paused"));
            }
            catch (RedshiftException e) {
                throw new RuntimeException("Failed to stop redshift cluster, needs to be stopped manually");
            }
        }
    }

    private void checkSnapshots() {
        DescribeClusterSnapshotsResponse respRecent = this.redshiftClient.describeClusterSnapshots(builder -> builder.clusterIdentifier(((RedshiftAccount)this.account).clusterIdentifier()).startTime(Instant.now().minus(5L, ChronoUnit.HOURS)));
        if (respRecent.snapshots().size() == 0) {
            LOG.debug("Create a snapshot");
            String id = "snapshot-tnb-" + new Date().getTime();
            this.redshiftClient.createClusterSnapshot(builder -> builder.clusterIdentifier(((RedshiftAccount)this.account).clusterIdentifier()).snapshotIdentifier(id).manualSnapshotRetentionPeriod(Integer.valueOf(1)));
            WaitUtils.waitFor(() -> ((Snapshot)this.redshiftClient.describeClusterSnapshots(builder -> builder.snapshotIdentifier(id)).snapshots().get(0)).status().equals("available"), (int)30, (long)10000L, (String)("Waiting for snapshot " + id + " to be available"));
            WaitUtils.waitFor(() -> !this.getCluster().clusterAvailabilityStatus().equalsIgnoreCase("modifying"), (int)30, (long)30000L, (String)("Waiting for Cluster " + this.getCluster().clusterIdentifier() + " to process the snapshot"));
        }
    }
}

