/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.aws.redshift.validation;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.Field;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.tnb.aws.redshift.account.RedshiftAccount;
import software.tnb.common.service.Validation;
import software.tnb.common.utils.WaitUtils;

public class RedshiftValidation
implements Validation {
    private final RedshiftClient redshiftClient;
    private final RedshiftDataClient redshiftDataClient;
    private final RedshiftAccount redshiftAccount;

    public RedshiftValidation(RedshiftClient redshiftClient, RedshiftDataClient redshiftDataClient, RedshiftAccount redshiftAccount) {
        this.redshiftClient = redshiftClient;
        this.redshiftDataClient = redshiftDataClient;
        this.redshiftAccount = redshiftAccount;
    }

    public String execSql(String sql) {
        Cluster cluster = this.redshiftClient.describeClusters().clusters().stream().filter(c -> c.clusterIdentifier().equals(this.redshiftAccount.clusterIdentifier())).findFirst().get();
        String responseId = this.redshiftDataClient.executeStatement((ExecuteStatementRequest)ExecuteStatementRequest.builder().clusterIdentifier(this.redshiftAccount.clusterIdentifier()).database(cluster.dbName()).dbUser(cluster.masterUsername()).sql(sql).build()).id();
        WaitUtils.waitFor(() -> {
            switch (this.getStatementStatus(responseId).toUpperCase()) {
                case "FINISHED": {
                    return true;
                }
                case "FAILED": {
                    Assertions.fail((String)String.format("Failure executing sql statement: '%s'", sql));
                }
            }
            return false;
        }, (int)20, (long)5000L, (String)("waiting until the statement " + sql + " is finished"));
        return responseId;
    }

    public List<List<Field>> records(String responseId) {
        GetStatementResultResponse response = this.redshiftDataClient.getStatementResult((GetStatementResultRequest)GetStatementResultRequest.builder().id(responseId).build());
        return response.records();
    }

    public String getStatementStatus(String responseId) {
        return this.redshiftDataClient.describeStatement(builder -> builder.id(responseId).build()).statusAsString();
    }
}

