/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.common.openshift;

import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.io.Closeable;
import java.util.function.Predicate;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.MapUtils;
import software.tnb.common.utils.NetworkUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.db.common.service.SQL;

public class OpenshiftDB
implements OpenshiftDeployable,
WithName {
    private LocalPortForward portForward;
    private int localPort;
    private final SQL sqlService;
    private final int port;
    private final String sccName;

    public OpenshiftDB(SQL sqlService, int port) {
        this.sqlService = sqlService;
        this.port = port;
        this.sccName = "tnb-openshift-db-" + OpenshiftClient.get().getNamespace();
    }

    public void create() {
        OpenshiftClient.get().addGroupsToSecurityContext(OpenshiftClient.get().createSecurityContext(this.sccName, "restricted", new String[0]), new String[]{"system:serviceaccounts:" + OpenshiftClient.get().getNamespace()});
        OpenshiftClient.get().apps().deployments().createOrReplace((Object[])new Deployment[]{((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ProbeFluent.TcpSocketNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().editOrNewSelector().addToMatchLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endSelector()).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).withNewSpec().addNewContainer().withName(this.name())).withImage(this.sqlService.image())).withSecurityContext(((SecurityContextBuilder)new SecurityContextBuilder().withAllowPrivilegeEscalation(Boolean.valueOf(true))).build())).addNewPort().withContainerPort(Integer.valueOf(this.port))).withName(this.name())).endPort()).withImagePullPolicy("IfNotPresent")).withEnv(MapUtils.toEnvVars(this.sqlService.containerEnvironment()))).withNewReadinessProbe().withNewTcpSocket().withNewPort(this.name())).endTcpSocket()).withInitialDelaySeconds(Integer.valueOf(5))).withTimeoutSeconds(Integer.valueOf(5))).withFailureThreshold(Integer.valueOf(6))).endReadinessProbe()).endContainer()).endSpec()).endTemplate()).endSpec()).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).withNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).addNewPort().withName(this.name())).withPort(Integer.valueOf(this.port))).withTargetPort(new IntOrString(Integer.valueOf(this.port)))).endPort()).endSpec()).build()});
    }

    public void undeploy() {
        ((Resource)OpenshiftClient.get().securityContextConstraints().withName(this.sccName)).delete();
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        ((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).delete();
        WaitUtils.waitFor(() -> this.servicePod() == null, (String)"Waiting until the pod is removed");
    }

    public void openResources() {
        this.localPort = NetworkUtils.getFreePort();
        this.portForward = (LocalPortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(this.port, this.localPort);
    }

    public void closeResources() {
        IOUtils.closeQuietly((Closeable)this.portForward);
        NetworkUtils.releasePort((int)this.localPort);
    }

    public boolean isDeployed() {
        Deployment deployment = (Deployment)((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).get();
        return deployment != null && !deployment.isMarkedForDeletion();
    }

    public Predicate<Pod> podSelector() {
        return super.podSelector();
    }

    public String name() {
        return this.sqlService.name();
    }

    public int localPort() {
        return this.localPort;
    }
}

