/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.google.cloud.functions.validation;

import com.google.cloud.functions.v1.CloudFunction;
import com.google.cloud.functions.v1.CloudFunctionName;
import com.google.cloud.functions.v1.CloudFunctionStatus;
import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import com.google.cloud.functions.v1.CreateFunctionRequest;
import com.google.cloud.functions.v1.DeleteFunctionRequest;
import com.google.cloud.functions.v1.HttpsTrigger;
import com.google.cloud.functions.v1.ListFunctionsRequest;
import com.google.cloud.functions.v1.LocationName;
import com.google.iam.v1.Binding;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.service.Validation;
import software.tnb.common.utils.WaitUtils;
import software.tnb.google.cloud.functions.account.GoogleFunctionsAccount;
import software.tnb.google.storage.service.GoogleStorage;

public class GoogleFunctionsValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleFunctionsValidation.class);
    private final GoogleFunctionsAccount account;
    private final CloudFunctionsServiceClient client;
    private final GoogleStorage storage;
    private final String bucketPrefix = "function-";
    private final Map<String, String> functionNames;

    public GoogleFunctionsValidation(GoogleFunctionsAccount account, CloudFunctionsServiceClient client, GoogleStorage storage) {
        this.account = account;
        this.client = client;
        this.storage = storage;
        this.functionNames = new HashMap<String, String>();
    }

    public void createFunction(String name, String region, String runtime, String entryPoint, Path zipSource) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("The function name must start with a letter followed by up to 62 letters, numbers, hyphens, or underscores and must end with a letter or a number! Was: \"" + name + "\"");
        }
        this.storage.validation().createBucket("function-" + name.toLowerCase());
        this.storage.validation().uploadFile("function-" + name.toLowerCase(), zipSource);
        String functionName = CloudFunctionName.format((String)this.account.projectId(), (String)region, (String)name);
        CloudFunction fx = CloudFunction.newBuilder().setName(functionName).setEntryPoint(entryPoint).setRuntime(runtime).setHttpsTrigger(HttpsTrigger.newBuilder().setSecurityLevel(HttpsTrigger.SecurityLevel.SECURE_OPTIONAL).build()).setSourceArchiveUrl(String.format("gs://%s/%s", "function-" + name, zipSource.getFileName().toString())).setServiceAccountEmail(this.account.clientEmail()).build();
        this.client.createFunctionCallable().call((Object)CreateFunctionRequest.newBuilder().setFunction(fx).setLocation(LocationName.format((String)this.account.projectId(), (String)region)).build());
        this.functionNames.put(functionName, name);
        this.client.setIamPolicy(SetIamPolicyRequest.newBuilder().setResource(functionName).setPolicy(Policy.newBuilder().addBindings(Binding.newBuilder().setRole("roles/cloudfunctions.invoker").addMembers("allUsers").build()).build()).build());
        WaitUtils.waitFor(() -> CloudFunctionStatus.ACTIVE == this.getFunction(functionName).getStatus(), (int)60, (long)2000L, (String)("Waiting until the function " + name + " is running"));
    }

    public void createFunction(String name, String runtime, String entryPoint, Path zipSource) {
        this.createFunction(name, this.account.region(), runtime, entryPoint, zipSource);
    }

    public CloudFunction getFunction(String name) {
        return this.client.getFunction(this.getFunctionName(name));
    }

    public List<CloudFunction> listFunctions() {
        return this.listFunctions(this.account.region());
    }

    public List<CloudFunction> listFunctions(String region) {
        ArrayList<CloudFunction> functions = new ArrayList<CloudFunction>();
        this.client.listFunctions(ListFunctionsRequest.newBuilder().setParent(LocationName.format((String)this.account.projectId(), (String)region)).build()).iterateAll().forEach(functions::add);
        return functions;
    }

    public String getUrl(String functionName) {
        return this.getFunction(this.getFunctionName(functionName)).getHttpsTrigger().getUrl();
    }

    public void deleteFunction(String functionName) {
        LOG.info("Deleting function {}", (Object)functionName);
        String cloudFunctionName = this.getFunctionName(functionName);
        try {
            this.client.deleteFunctionCallable().call((Object)DeleteFunctionRequest.newBuilder().setName(cloudFunctionName).build());
        }
        finally {
            this.storage.validation().deleteBucket("function-" + StringUtils.substringAfterLast((String)cloudFunctionName, (String)"/").toLowerCase());
        }
    }

    private boolean isValidName(String name) {
        return name.length() > 0 && name.length() <= 63 && name.matches("^[a-zA-Z].*") && name.matches(".*[a-zA-Z0-9]$");
    }

    private String getFunctionName(String name) {
        if (name.matches("projects/.*/locations/.*/functions/.*")) {
            return name;
        }
        if (this.functionNames.containsValue(name)) {
            List entries = this.functionNames.entrySet().stream().filter(e -> name.equals(e.getValue())).collect(Collectors.toList());
            if (entries.size() > 1) {
                throw new IllegalArgumentException("Multiple functions with the same name exist (in different location)! Use either a full function name (projects/<project>/locations/<location>/functions/<name>) or use a method with region and function name parameters");
            }
            return (String)((Map.Entry)entries.get(0)).getKey();
        }
        throw new IllegalArgumentException("No function with the name \"" + name + "\" was created in this execution! If you want to use a previously created function, use either a full function name (projects/<project>/locations/<location>/functions/<name>) or use a method with region and function name parameters");
    }
}

