/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.throwaway.ThrowawayControllerHandlerAdapter;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String HANDLER_EXECUTION_CHAIN_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".HANDLER";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".CONTEXT";
    public static final String MULTIPART_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".MULTIPART";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".LOCALE";
    public static final String THEME_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private boolean cleanupAfterInclude = true;
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private List viewResolvers;
    static /* synthetic */ Class class$org$springframework$web$servlet$DispatcherServlet;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerExceptionResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ViewResolver;

    public void setCleanupAfterInclude(boolean cleanupAfterInclude) {
        this.cleanupAfterInclude = cleanupAfterInclude;
    }

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.initMultipartResolver();
        this.initLocaleResolver();
        this.initThemeResolver();
        this.initHandlerMappings();
        this.initHandlerAdapters();
        this.initHandlerExceptionResolvers();
        this.initViewResolvers();
    }

    private void initMultipartResolver() throws BeansException {
        block3: {
            try {
                this.multipartResolver = (MultipartResolver)this.getWebApplicationContext().getBean(MULTIPART_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling provided");
            }
        }
    }

    private void initLocaleResolver() throws BeansException {
        block3: {
            try {
                this.localeResolver = (LocaleResolver)this.getWebApplicationContext().getBean(LOCALE_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.localeResolver = new AcceptHeaderLocaleResolver();
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
            }
        }
    }

    private void initThemeResolver() throws BeansException {
        block3: {
            try {
                this.themeResolver = (ThemeResolver)this.getWebApplicationContext().getBean(THEME_RESOLVER_BEAN_NAME);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.themeResolver = new FixedThemeResolver();
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
            }
        }
    }

    private void initHandlerMappings() throws BeansException {
        Object hm;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)(class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping), (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                Collections.sort(this.handlerMappings, new OrderComparator());
            }
        } else {
            try {
                hm = this.getWebApplicationContext().getBean(HANDLER_MAPPING_BEAN_NAME);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            hm = new BeanNameUrlHandlerMapping();
            hm.setApplicationContext((ApplicationContext)this.getWebApplicationContext());
            this.handlerMappings = Collections.singletonList(hm);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerAdapters() throws BeansException {
        Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)(class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter), (boolean)true, (boolean)false);
        if (!matchingBeans.isEmpty()) {
            this.handlerAdapters = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerAdapters, new OrderComparator());
        } else {
            this.handlerAdapters = new ArrayList(2);
            this.handlerAdapters.add(new SimpleControllerHandlerAdapter());
            this.handlerAdapters.add(new ThrowawayControllerHandlerAdapter());
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    private void initHandlerExceptionResolvers() throws BeansException {
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)(class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver), (boolean)true, (boolean)false);
            this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
        } else {
            try {
                Object her = this.getWebApplicationContext().getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.handlerExceptionResolvers = Collections.EMPTY_LIST;
            }
        }
    }

    private void initViewResolvers() throws BeansException {
        Object vr;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getWebApplicationContext(), (Class)(class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver), (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                Collections.sort(this.viewResolvers, new OrderComparator());
            }
        } else {
            try {
                vr = this.getWebApplicationContext().getBean(VIEW_RESOLVER_BEAN_NAME);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            vr = new InternalResourceViewResolver();
            vr.setApplicationContext((ApplicationContext)this.getWebApplicationContext());
            this.viewResolvers = Collections.singletonList(vr);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "' received request for [" + request.getRequestURI() + "]"));
        }
        HashMap<String, Object> attributesSnapshot = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            this.logger.debug((Object)"Taking snapshot of request attributes before include");
            attributesSnapshot = new HashMap<String, Object>();
            Enumeration attrNames = request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                if (!this.cleanupAfterInclude && !attrName.startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
                attributesSnapshot.put(attrName, request.getAttribute(attrName));
            }
        }
        request.setAttribute(WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
        request.setAttribute(LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
        request.setAttribute(THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
        try {
            this.doDispatch(request, response);
        }
        finally {
            if (attributesSnapshot != null) {
                this.restoreAttributesAfterInclude(request, attributesSnapshot);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            HandlerExecutionChain mappedHandler = this.getHandler(request, true);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Last-Modified value for [" + request.getRequestURI() + "] is [" + lastModified + "]"));
            }
            return lastModified;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)ex);
            return -1L;
        }
    }

    private HttpServletRequest checkMultipart(HttpServletRequest request) throws MultipartException {
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
            if (request instanceof MultipartHttpServletRequest) {
                this.logger.info((Object)"Request is already a MultipartHttpServletRequest - if not in a forward, this typically results from an additional MultipartFilter in web.xml");
            } else {
                request.setAttribute(MULTIPART_RESOLVER_ATTRIBUTE, (Object)this.multipartResolver);
                return this.multipartResolver.resolveMultipart(request);
            }
        }
        return request;
    }

    private HandlerExecutionChain getHandler(HttpServletRequest request, boolean cache) throws Exception {
        HandlerExecutionChain handler = (HandlerExecutionChain)request.getAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
        if (handler != null) {
            if (!cache) {
                request.removeAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE);
            }
            return handler;
        }
        Iterator it = this.handlerMappings.iterator();
        while (it.hasNext()) {
            HandlerMapping hm = (HandlerMapping)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            }
            if ((handler = hm.getHandler(request)) == null) continue;
            if (cache) {
                request.setAttribute(HANDLER_EXECUTION_CHAIN_ATTRIBUTE, (Object)handler);
            }
            return handler;
        }
        return null;
    }

    private void noHandlerFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (pageNotFoundLogger.isWarnEnabled()) {
            pageNotFoundLogger.warn((Object)("No mapping for [" + request.getRequestURI() + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        response.sendError(404);
    }

    private HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Iterator it = this.handlerAdapters.iterator();
        while (it.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)it.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            }
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    private ModelAndView processHandlerException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ModelAndView exMv = null;
        Iterator it = this.handlerExceptionResolvers.iterator();
        while (exMv == null && it.hasNext()) {
            HandlerExceptionResolver resolver = (HandlerExceptionResolver)it.next();
            exMv = resolver.resolveException(request, response, handler, ex);
        }
        if (exMv != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
            }
            this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
            return exMv;
        }
        throw ex;
    }

    private void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = this.localeResolver.resolveLocale(request);
        response.setLocale(locale);
        View view = null;
        if (mv.isReference()) {
            Iterator it = this.viewResolvers.iterator();
            while (it.hasNext() && view == null) {
                ViewResolver viewResolver = (ViewResolver)it.next();
                view = viewResolver.resolveViewName(mv.getViewName(), locale);
            }
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mv.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = mv.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mv + "] neither contains a view name nor a " + "View object in servlet with name '" + this.getServletName() + "'");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view [" + view + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
        }
        view.render(mv.getModelInternal(), request, response);
    }

    private void triggerAfterCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        if (mappedHandler != null && mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Throwable ex2) {
                    this.logger.error((Object)"HandlerInterceptor.afterCompletion threw exception", ex2);
                }
            }
        }
    }

    private void restoreAttributesAfterInclude(HttpServletRequest request, Map attributesSnapshot) {
        this.logger.debug((Object)"Restoring snapshot of request attributes after include");
        HashSet<String> attrsToCheck = new HashSet<String>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            if (!this.cleanupAfterInclude && !attrName.startsWith((class$org$springframework$web$servlet$DispatcherServlet == null ? DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet") : class$org$springframework$web$servlet$DispatcherServlet).getName())) continue;
            attrsToCheck.add(attrName);
        }
        Iterator it = attrsToCheck.iterator();
        while (it.hasNext()) {
            String attrName = (String)it.next();
            Object attrValue = attributesSnapshot.get(attrName);
            if (attrValue != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring original value of attribute [" + attrName + "] after include"));
                }
                request.setAttribute(attrName, attrValue);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing attribute [" + attrName + "] after include"));
            }
            request.removeAttribute(attrName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

