/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;

public abstract class AbstractView
extends WebApplicationObjectSupport
implements View,
BeanNameAware {
    public static final String DEFAULT_CONTENT_TYPE = "text/html; charset=ISO-8859-1";
    private String beanName;
    private String contentType = "text/html; charset=ISO-8859-1";
    private String requestContextAttribute;
    private final Map staticAttributes = new HashMap();

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setAttributesCSV(String propString) throws IllegalArgumentException {
        if (propString == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(propString, ",");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int eqIdx = tok.indexOf("=");
            if (eqIdx == -1) {
                throw new IllegalArgumentException("Expected = in attributes CSV string '" + propString + "'");
            }
            if (eqIdx >= tok.length() - 2) {
                throw new IllegalArgumentException("At least 2 characters ([]) required in attributes CSV string '" + propString + "'");
            }
            String name = tok.substring(0, eqIdx);
            String value = tok.substring(eqIdx + 1);
            value = value.substring(1);
            value = value.substring(0, value.length() - 1);
            this.addStaticAttribute(name, value);
        }
    }

    public void setAttributes(Properties props) {
        this.setAttributesMap(props);
    }

    public void setAttributesMap(Map attributes) {
        if (attributes != null) {
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Object value = attributes.get(name);
                this.addStaticAttribute(name, value);
            }
        }
    }

    public Map getAttributesMap() {
        return this.staticAttributes;
    }

    public void addStaticAttribute(String name, Object value) {
        this.staticAttributes.put(name, value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set static attribute with name '" + name + "' and value [" + value + "] on view with name '" + this.getBeanName() + "'"));
        }
    }

    public Map getStaticAttributes() {
        return Collections.unmodifiableMap(this.staticAttributes);
    }

    public void render(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rendering view with name '" + this.beanName + "' with model " + model + " and static attributes " + this.staticAttributes));
        }
        HashMap<String, RequestContext> mergedModel = new HashMap<String, RequestContext>(this.staticAttributes.size() + (model != null ? model.size() : 0));
        mergedModel.putAll(this.staticAttributes);
        if (model != null) {
            mergedModel.putAll(model);
        }
        if (this.requestContextAttribute != null) {
            mergedModel.put(this.requestContextAttribute, this.createRequestContext(request, mergedModel));
        }
        this.renderMergedOutputModel(mergedModel, request, response);
    }

    protected RequestContext createRequestContext(HttpServletRequest request, Map model) {
        return new RequestContext(request, model);
    }

    protected abstract void renderMergedOutputModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        if (this.getBeanName() != null) {
            sb.append(": name '").append(this.getBeanName()).append("'");
        } else {
            sb.append(": unnamed");
        }
        return sb.toString();
    }
}

