package tech.amwal.justpassme

import tech.amwal.justpassme.http.WebAuthnHttp
import tech.amwal.justpassme.model.toPublicKeyCredentialCreation
import tech.amwal.justpassme.model.toPublicKeyCredentialRequest
import tech.amwal.justpassme.proxy.WebAuthnProxy

internal class WebauthnRepository(
    private val webAuthnProxy: WebAuthnProxy,
    private val webAuthnHttp: WebAuthnHttp,
    private val sessionId: String
) {

    internal suspend fun register(): Map<String, *> {
        val publicKey = webAuthnHttp
            .getPublicKey(sessionId = sessionId)
            .publicKey
            .toPublicKeyCredentialCreation()
        val registrationResponse = webAuthnProxy.registerUser(publicKey)
        webAuthnHttp.verifyRegistration(
            registrationResponse,
            sessionId = sessionId
        )
        return webAuthnHttp.backToClient(sessionId = sessionId)
    }

    internal suspend fun auth(): Map<String, *> {
        val publicKey =
            webAuthnHttp.getPublicKeyAuth(sessionId = sessionId).publicKey.toPublicKeyCredentialRequest()
        val signInResponse = webAuthnProxy.signInUser(publicKey)
        webAuthnHttp.auth(signInResponse, sessionId = sessionId)
        return webAuthnHttp.backToClient(sessionId = sessionId)
    }
}
