package tech.amwal.justpassme.model

import android.util.Base64
import com.google.android.gms.fido.fido2.api.common.Attachment
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRequestOptions
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement
import com.google.android.gms.fido.fido2.api.common.UserVerificationMethodExtension
import tech.amwal.justpassme.model.auth.AssertionOptionsPublicKey

@Suppress("MagicNumber")
internal fun PublicKeyWrapper.PublicKey.toPublicKeyCredentialCreation(): PublicKeyCredentialCreationOptions =
    PublicKeyCredentialCreationOptions.Builder().apply {
        setChallenge(challenge.decodeBase64())
        setUser(
            PublicKeyCredentialUserEntity(
                user.id.decodeBase64(), user.name, "", user.displayName
            )
        )
        setRp(
            PublicKeyCredentialRpEntity(
                rp.id, rp.name, null
            )
        )
        setAuthenticationExtensions(
            AuthenticationExtensions.Builder().apply {
                this.setUserVerificationMethodExtension(UserVerificationMethodExtension(true))
            }.build()
        )

        setParameters(pubKeyCredParams.filter { it.alg != -8 }
            .map { PublicKeyCredentialParameters(it.type, it.alg) })
        setAuthenticatorSelection(
            AuthenticatorSelectionCriteria.Builder().apply {
                setAttachment(Attachment.fromString(authenticatorSelection.authenticatorAttachment))
                setResidentKeyRequirement(
                    ResidentKeyRequirement.fromString(
                        authenticatorSelection.residentKey
                    )
                )
            }.build()
        )
    }.build()

internal fun AssertionOptionsPublicKey.toPublicKeyCredentialRequest() =
    PublicKeyCredentialRequestOptions.Builder().apply {
        setChallenge(challenge.decodeBase64())
        setRpId(relyingPartyId)
        setAuthenticationExtensions(
            AuthenticationExtensions.Builder().setUserVerificationMethodExtension(
                UserVerificationMethodExtension((true))
            ).build()
        )
    }.build()

private const val BASE64_FLAG = Base64.NO_PADDING or Base64.NO_WRAP or Base64.URL_SAFE
private fun ByteArray.toBase64(): String {
    return Base64.encodeToString(this, BASE64_FLAG)
}

private fun String.decodeBase64(): ByteArray {
    return Base64.decode(this, BASE64_FLAG)
}
