package tech.amwal.justpassme.model


import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class PublicKeyWrapper(
    @SerialName("publicKey")
    val publicKey: PublicKey = PublicKey()
){
    @Serializable
    data class PublicKey(
        @SerialName("authenticatorSelection")
        val authenticatorSelection: AuthenticatorSelection = AuthenticatorSelection(),
        @SerialName("challenge")
        val challenge: String = "",
        @SerialName("excludeCredentials")
        val excludeCredentials: List<PubKeyCredParam> = listOf(),
        @SerialName("pubKeyCredParams")
        val pubKeyCredParams: List<PubKeyCredParam> = listOf(),
        @SerialName("rp")
        val rp: Rp = Rp(),
        @SerialName("user")
        val user: User = User()
    ){
        @Serializable
        data class Rp(
            @SerialName("id")
            val id: String = "",
            @SerialName("name")
            val name: String = ""
        )

        @Serializable
        data class User(
            @SerialName("displayName")
            val displayName: String = "",
            @SerialName("id")
            val id: String = "",
            @SerialName("name")
            val name: String = ""
        )

        @Serializable
        data class PubKeyCredParam(
            @SerialName("alg")
            val alg: Int = 0,
            @SerialName("type")
            val type: String = ""
        )

        @Serializable
        data class AuthenticatorSelection(
            @SerialName("authenticatorAttachment")
            val authenticatorAttachment: String = "",
            @SerialName("requireResidentKey")
            val requireResidentKey: Boolean = false,
            @SerialName("residentKey")
            val residentKey: String = ""
        )
    }
}