package tech.amwal.justpassme.model.auth

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class AssertionOptionsPublicKey(
    @SerialName("challenge")
    val challenge: String,
    @SerialName("rpId")
    val relyingPartyId: String,
    @SerialName("allowCredentials")
    val allowCredentials: List<Pair<String, String>> = listOf()
)

@Serializable
internal data class PublicKeyAssertionWrapper(
    @SerialName("publicKey")
    val publicKey: AssertionOptionsPublicKey,
)