package tech.amwal.justpassme.model.auth

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class AuthenticationPublicKey(
    @SerialName("id")
    val id: String,
    @SerialName("rawId")
    val rawId: String,
    @SerialName("type")
    val type: String = "public-key",
    @SerialName("response")
    val response: Response,


    ) {
    @Serializable
    internal data class Response(
        @SerialName("userHandle")
        val userHandle: String?,
        @SerialName("authenticatorData")
        val authenticatorData: String?,
        @SerialName("signature")
        val signature: String,
        @SerialName("clientDataJSON")
        val assertionDataJSON: String
    )
}
