package tech.amwal.justpassme.model.register

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class CreationOptions(
    @SerialName("challenge")
    val challenge: String,
    @SerialName("rp")
    val relyingParty: RelyingParty,
    @SerialName("user")
    val user: User,
    @SerialName("timeout")
    val timeout: String,
    @SerialName("attestation")
    val attestation: String,
    @SerialName("pubKeyCredParams")
    val publicKeys: List<PublicKeyCredentials>,
    @SerialName("authenticatorSelection")
    val authenticator: Authenticator

) {
    @Serializable
    internal data class User(
        @SerialName("id")
        val id: String,
        @SerialName("name")
        val name: String,
        @SerialName("displayName")
        val displayName: String? = ""
    )

    @Serializable
    internal data class RelyingParty(
        @SerialName("id")
        val id: String,
        @SerialName("name")
        val name: String
    )

    @Serializable
    internal data class PublicKeyCredentials(
        @SerialName("type")
        val type: String,
        @SerialName("alg")
        val algorithm: Int
    )

    @Serializable
    internal data class Authenticator(
        @SerialName("authenticatorAttachment")
        val attachment: String,
        @SerialName("residentKey")
        val residentKey: String
    )
}
