package tech.amwal.justpassme.model.register

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class RegistrationPublicKey(
    @SerialName("id")
    val id: String,
    @SerialName("rawId")
    val rawId: String,
    @SerialName("type")
    val type: String = "public-key",
    @SerialName("response")
    val response: Response
) {
    @Serializable
    internal data class Response(
        @SerialName("clientDataJSON")
        val client: String,
        @SerialName("attestationObject")
        val attestation: String
    )
}
