package tech.amwal.components.local

import android.content.Context
import androidx.security.crypto.EncryptedSharedPreferences
import androidx.security.crypto.MasterKeys
import com.russhwolf.settings.Settings
import com.russhwolf.settings.SharedPreferencesSettings
class AndroidSettingsStore(private val context: Context) : SettingsStore() {
    private val masterKeyAlias = MasterKeys.getOrCreate(MasterKeys.AES256_GCM_SPEC)

    override fun getEncryptedSettings(): Settings {
        return SharedPreferencesSettings(
            EncryptedSharedPreferences.create(
                ENCRYPTED_DATABASE_NAME,
                masterKeyAlias,
                context,
                EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV,
                EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM
            ),
            false
        )
    }
}
