package tech.amwal.components.resources

import java.util.Locale

actual object Locales {
    actual fun currentLanguage(): String = Locale.getDefault().language

    actual fun currentCountry(): String = Locale.getDefault().country
    actual fun allCountries(): List<String> = Locale.getISOCountries().toList()
    actual fun getCountryName(isoCode: String): String =
        Locale("", isoCode).getDisplayCountry(Locale.getDefault())
}
