package tech.amwal.launcher.presentation

import tech.amwal.components.presentation.Result

sealed interface LauncherResults : Result {
    object InFlight : LauncherResults
    object PhoneNumberRequired : LauncherResults
    object PaymentMethodMissing : LauncherResults
    data class OtpAndBiometricsRegistrationRequired(val phoneNumber: String) : LauncherResults
    object AuthBiometrics : LauncherResults
    data class Error(val error: Throwable) : LauncherResults
}
