package tech.amwal.phone.domain.usecase

import tech.amwal.phone.domain.PhoneNumberRepository

class SavePhoneNumber(private val repository: PhoneNumberRepository) {
    suspend operator fun invoke(phoneNumber: String?, countryCode: String?) {
        if (!phoneNumber.isNullOrBlank() && !countryCode.isNullOrBlank()) {
            repository.savePhoneNumber(
                phoneNumber,
                countryCode
            )
        }
    }
}
