/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import tech.bitey.bufferstuff.BufferUtils;

public class BufferSort {
    public static void inplaceSort(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.heapSort(b, fromIndex, toIndex);
    }

    private static void heapSort(IntBuffer b, int fromIndex, int toIndex) {
        int i;
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(IntBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(IntBuffer b, int i, int j) {
        int swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void inplaceSort(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.heapSort(b, fromIndex, toIndex);
    }

    private static void heapSort(LongBuffer b, int fromIndex, int toIndex) {
        int i;
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(LongBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(LongBuffer b, int i, int j) {
        long swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void inplaceSort(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.heapSort(b, fromIndex, toIndex);
    }

    private static void heapSort(FloatBuffer b, int fromIndex, int toIndex) {
        int i;
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(FloatBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && Float.compare(b.get(l), b.get(largest)) > 0) {
            largest = l;
        }
        if (r < n && Float.compare(b.get(r), b.get(largest)) > 0) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(FloatBuffer b, int i, int j) {
        float swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void inplaceSort(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.heapSort(b, fromIndex, toIndex);
    }

    private static void heapSort(DoubleBuffer b, int fromIndex, int toIndex) {
        int i;
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(DoubleBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && Double.compare(b.get(l), b.get(largest)) > 0) {
            largest = l;
        }
        if (r < n && Double.compare(b.get(r), b.get(largest)) > 0) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(DoubleBuffer b, int i, int j) {
        double swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }
}

