/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public enum BufferUtils {


    public static ByteBuffer duplicate(ByteBuffer b) {
        return b.duplicate().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b) {
        return b.slice().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        ByteBuffer dup = BufferUtils.duplicate(b);
        dup.limit(toIndex);
        dup.position(fromIndex);
        return BufferUtils.slice(dup);
    }

    public static boolean isSorted(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    static void rangeCheck(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex > bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") > " + bufferCapacity);
        }
    }
}

