/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.BitSet;
import java.util.Random;
import tech.bitey.bufferstuff.BufferUtils;

public class BufferBitSet
implements Cloneable {
    public static final BufferBitSet EMPTY_BITSET = new BufferBitSet(false);
    private static final int DEFAULT_INITIAL_SIZE = 8;
    private static final int MASK = 255;
    private final boolean resizable;
    private ByteBuffer buffer;

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    private BufferBitSet(ByteBuffer buffer, boolean resizable, boolean externalBuffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        if (externalBuffer) {
            this.buffer = buffer.slice();
            this.buffer.position(this.buffer.limit());
            this.recalculateBytesInUse();
        } else {
            this.buffer = buffer;
        }
        this.resizable = resizable;
    }

    public BufferBitSet() {
        this(true);
    }

    public BufferBitSet(boolean resizable) {
        this(BufferUtils.allocate(8), resizable, false);
    }

    public BufferBitSet(ByteBuffer buffer) {
        this(buffer, false, true);
    }

    public BufferBitSet(ByteBuffer buffer, boolean resizable) {
        this(buffer, resizable, true);
    }

    public static BufferBitSet valueOf(byte[] bytes) {
        int n;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (n = buffer.limit() - 1; n >= 0 && buffer.get(n) == 0; --n) {
        }
        buffer.position(n + 1);
        return new BufferBitSet(buffer, true, false);
    }

    public static BufferBitSet valueOf(BitSet bs) {
        byte[] array = bs.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.limit(array.length);
        buffer.position(array.length);
        return new BufferBitSet(buffer, true, false);
    }

    public BufferBitSet resizable(boolean resizable) {
        return new BufferBitSet(BufferUtils.duplicate(this.buffer), resizable, false);
    }

    public static BufferBitSet random(int n, int size) {
        Random random = new Random();
        return BufferBitSet.random(n, size, random);
    }

    static BufferBitSet random(int n, int size, Random random) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be > 1");
        }
        if (n < 0 || n > size) {
            throw new IllegalArgumentException("n must between 0 and size inclusive");
        }
        BufferBitSet bbs = new BufferBitSet();
        bbs.set(0, n);
        for (int i = size; i > 1; --i) {
            int r = random.nextInt(i);
            boolean temp = bbs.get(r);
            bbs.set(r, bbs.get(i - 1));
            bbs.set(i - 1, temp);
        }
        return bbs;
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = this.buffer.duplicate();
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    public BitSet toBitSet() {
        return BitSet.valueOf(this.toByteArray());
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        this.writeTo(channel, 0, this.length());
    }

    public void writeTo(WritableByteChannel channel, int fromIndex, int toIndex) throws IOException {
        int n;
        BufferBitSet.checkRange(fromIndex, toIndex);
        int length = this.length();
        if (fromIndex >= length) {
            fromIndex = 0;
            toIndex = 0;
        } else if (toIndex > length) {
            toIndex = length;
        }
        ByteBuffer buffer = BufferUtils.slice(this.buffer, BufferBitSet.byteIndex(fromIndex), BufferBitSet.byteIndex(toIndex - 1) + 1);
        for (n = buffer.limit() - 1; n >= 0 && buffer.get(n) == 0; --n) {
        }
        buffer.limit(n + 1);
        int limit = buffer.limit();
        ByteBuffer header = ByteBuffer.allocate(5).order(ByteOrder.BIG_ENDIAN);
        header.put(0, (byte)(fromIndex & 7));
        header.putInt(1, limit);
        channel.write(header);
        if (limit > 0) {
            if (limit > 1) {
                channel.write(BufferUtils.slice(buffer, 0, limit - 1));
            }
            ByteBuffer lastByte = ByteBuffer.allocate(1);
            lastByte.put(0, (byte)(buffer.get(limit - 1) & 255 >>> (-toIndex & 7)));
            channel.write(lastByte);
        }
    }

    public static BufferBitSet readFrom(ReadableByteChannel channel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(5).order(ByteOrder.BIG_ENDIAN);
        channel.read(header);
        byte offset = header.get(0);
        int capacity = header.getInt(1);
        if (capacity == 0) {
            return EMPTY_BITSET;
        }
        ByteBuffer buffer = BufferUtils.allocate(capacity);
        channel.read(buffer);
        if (offset == 0) {
            return new BufferBitSet(buffer, false, false);
        }
        int limit = buffer.limit();
        for (int i = 0; i < limit - 1; ++i) {
            buffer.put(i, (byte)((buffer.get(i) & 0xFF) >>> offset | buffer.get(i + 1) << (-offset & 7)));
        }
        buffer.put(limit - 1, (byte)((buffer.get(limit - 1) & 0xFF) >>> offset));
        buffer.clear();
        return new BufferBitSet(buffer, false, true);
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int byteIndex = BufferBitSet.byteIndex(bitIndex);
        return byteIndex < this.buffer.position() && (this.byt(byteIndex) & BufferBitSet.bit(bitIndex)) != 0;
    }

    public BufferBitSet get(int fromIndex, int toIndex) {
        BufferBitSet.checkRange(fromIndex, toIndex);
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return new BufferBitSet(this.resizable);
        }
        if (toIndex > len) {
            toIndex = len;
        }
        int targetBytes = BufferBitSet.byteIndex(toIndex - fromIndex - 1) + 1;
        ByteBuffer resultBuffer = BufferUtils.allocate(targetBytes);
        BufferBitSet result = new BufferBitSet(resultBuffer, this.resizable, false);
        int sourceIndex = BufferBitSet.byteIndex(fromIndex);
        boolean byteAligned = (fromIndex & 7) == 0;
        int i = 0;
        while (i < targetBytes - 1) {
            resultBuffer.put(i, (byte)(byteAligned ? this.byt(sourceIndex) : (this.byt(sourceIndex) & 0xFF) >>> (fromIndex & 7) | this.byt(sourceIndex + 1) << (-fromIndex & 7)));
            ++i;
            ++sourceIndex;
        }
        int lastWordMask = 255 >>> (-toIndex & 7);
        resultBuffer.put(targetBytes - 1, (byte)((toIndex - 1 & 7) < (fromIndex & 7) ? (this.byt(sourceIndex) & 0xFF) >>> (fromIndex & 7) | (this.byt(sourceIndex + 1) & lastWordMask) << (-fromIndex & 7) : (this.byt(sourceIndex) & lastWordMask) >>> (fromIndex & 7)));
        result.buffer.position(targetBytes);
        result.recalculateBytesInUse();
        return result;
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int byteIndex = BufferBitSet.byteIndex(bitIndex);
        this.expandTo(byteIndex);
        this.put(byteIndex, this.byt(byteIndex) | BufferBitSet.bit(bitIndex));
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int fromIndex, int toIndex) {
        BufferBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startByteIndex = BufferBitSet.byteIndex(fromIndex);
        int endByteIndex = BufferBitSet.byteIndex(toIndex - 1);
        this.expandTo(endByteIndex);
        int firstByteMask = 255 << (fromIndex & 7);
        int lastByteMask = 255 >>> (-toIndex & 7);
        if (startByteIndex == endByteIndex) {
            this.put(startByteIndex, this.byt(startByteIndex) | firstByteMask & lastByteMask);
        } else {
            this.put(startByteIndex, this.byt(startByteIndex) | firstByteMask);
            for (int i = startByteIndex + 1; i < endByteIndex; ++i) {
                this.put(i, 255);
            }
            this.put(endByteIndex, this.byt(endByteIndex) | lastByteMask);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public void flip(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int byteIndex = BufferBitSet.byteIndex(bitIndex);
        this.expandTo(byteIndex);
        this.put(byteIndex, this.byt(byteIndex) ^ BufferBitSet.bit(bitIndex));
        this.recalculateBytesInUse();
    }

    public void flip(int fromIndex, int toIndex) {
        BufferBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startByteIndex = BufferBitSet.byteIndex(fromIndex);
        int endByteIndex = BufferBitSet.byteIndex(toIndex - 1);
        this.expandTo(endByteIndex);
        int firstByteMask = 255 << (fromIndex & 7);
        int lastByteMask = 255 >>> (-toIndex & 7);
        if (startByteIndex == endByteIndex) {
            this.put(startByteIndex, this.byt(startByteIndex) ^ firstByteMask & lastByteMask);
        } else {
            this.put(startByteIndex, this.byt(startByteIndex) ^ firstByteMask);
            for (int i = startByteIndex + 1; i < endByteIndex; ++i) {
                this.put(i, this.byt(i) ^ 0xFF);
            }
            this.put(endByteIndex, this.byt(endByteIndex) ^ lastByteMask);
        }
        this.recalculateBytesInUse();
    }

    public void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int byteIndex = BufferBitSet.byteIndex(bitIndex);
        if (byteIndex >= this.buffer.position()) {
            return;
        }
        this.put(byteIndex, this.byt(byteIndex) & ~BufferBitSet.bit(bitIndex));
        this.recalculateBytesInUse();
    }

    public void clear(int fromIndex, int toIndex) {
        BufferBitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int startByteIndex = BufferBitSet.byteIndex(fromIndex);
        int endByteIndex = BufferBitSet.byteIndex(toIndex - 1);
        this.expandTo(endByteIndex);
        int firstByteMask = 255 << (fromIndex & 7);
        int lastByteMask = 255 >>> (-toIndex & 7);
        if (startByteIndex == endByteIndex) {
            this.put(startByteIndex, this.byt(startByteIndex) & ~(firstByteMask & lastByteMask));
        } else {
            this.put(startByteIndex, this.byt(startByteIndex) & ~firstByteMask);
            for (int i = startByteIndex + 1; i < endByteIndex; ++i) {
                this.put(i, 0);
            }
            this.put(endByteIndex, this.byt(endByteIndex) & ~lastByteMask);
        }
        this.recalculateBytesInUse();
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int position = this.buffer.position();
        int u = BufferBitSet.byteIndex(fromIndex);
        if (u >= position) {
            return -1;
        }
        byte b = (byte)(this.byt(u) & 255 << (fromIndex & 7));
        while (b == 0) {
            if (++u == position) {
                return -1;
            }
            b = this.byt(u);
        }
        return u * 8 + Integer.numberOfTrailingZeros(b);
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int position = this.buffer.position();
        int u = BufferBitSet.byteIndex(fromIndex);
        if (u >= position) {
            return fromIndex;
        }
        byte b = (byte)(~this.byt(u) & 255 << (fromIndex & 7));
        while (b == 0) {
            if (++u == position) {
                return position * 8;
            }
            b = ~this.byt(u);
        }
        return u * 8 + Integer.numberOfTrailingZeros(b);
    }

    public int previousSetBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = BufferBitSet.byteIndex(fromIndex);
        if (u >= this.buffer.position()) {
            return this.length() - 1;
        }
        byte b = (byte)(this.byt(u) & 255 >>> (-(fromIndex + 1) & 7));
        while (b == 0) {
            if (u-- == 0) {
                return -1;
            }
            b = this.byt(u);
        }
        return (u + 1) * 8 - 1 - BufferBitSet.numberOfLeadingZeros(b);
    }

    public int previousClearBit(int fromIndex) {
        if (fromIndex < 0) {
            if (fromIndex == -1) {
                return -1;
            }
            throw new IndexOutOfBoundsException("fromIndex < -1: " + fromIndex);
        }
        int u = BufferBitSet.byteIndex(fromIndex);
        if (u >= this.buffer.position()) {
            return fromIndex;
        }
        byte b = (byte)(~this.byt(u) & 255 >>> (-(fromIndex + 1) & 7));
        while (b == 0) {
            if (u-- == 0) {
                return -1;
            }
            b = ~this.byt(u);
        }
        return (u + 1) * 8 - 1 - BufferBitSet.numberOfLeadingZeros(b);
    }

    public void and(BufferBitSet set) {
        if (this == set) {
            return;
        }
        int position = this.buffer.position();
        int setPosition = set.buffer.position();
        while (position > setPosition) {
            this.put(--position, 0);
        }
        this.buffer.position(position);
        for (int i = 0; i < position; ++i) {
            this.put(i, this.byt(i) & set.byt(i));
        }
        this.recalculateBytesInUse();
    }

    public void or(BufferBitSet set) {
        if (this == set) {
            return;
        }
        int bytesInCommon = Math.min(this.buffer.position(), set.buffer.position());
        for (int i = 0; i < bytesInCommon; ++i) {
            this.put(i, this.byt(i) | set.byt(i));
        }
        this.copyRemainingBytes(bytesInCommon, set);
    }

    public void xor(BufferBitSet set) {
        int bytesInCommon = Math.min(this.buffer.position(), set.buffer.position());
        for (int i = 0; i < bytesInCommon; ++i) {
            this.put(i, this.byt(i) ^ set.byt(i));
        }
        this.copyRemainingBytes(bytesInCommon, set);
        this.recalculateBytesInUse();
    }

    public void andNot(BufferBitSet set) {
        int bytesInCommon = Math.min(this.buffer.position(), set.buffer.position());
        for (int i = bytesInCommon - 1; i >= 0; --i) {
            this.put(i, this.byt(i) & ~set.byt(i));
        }
        this.recalculateBytesInUse();
    }

    public BufferBitSet shiftRight(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset < 0: " + offset);
        }
        int offsetBytes = (offset - 1) / 8 + 1;
        int totalBytes = offsetBytes + this.buffer.position();
        ByteBuffer buffer = BufferUtils.allocate(totalBytes);
        buffer.position(offsetBytes);
        ByteBuffer from = this.buffer.duplicate();
        from.flip();
        buffer.put(from);
        BufferBitSet bs = new BufferBitSet(buffer, this.resizable, false);
        int actualOffset = offsetBytes * 8;
        if (actualOffset > offset) {
            int leftShift = actualOffset - offset;
            return bs.get(leftShift, totalBytes * 8 + 1);
        }
        return bs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int position = this.buffer.position();
        for (int i = 0; i < position; ++i) {
            int b = this.byt(i) & 0xFF;
            int j = 0;
            while (b > 0) {
                if ((b & 1) != 0) {
                    sb.append((i << 3) + j);
                    sb.append(", ");
                }
                b >>= 1;
                ++j;
            }
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    public int length() {
        if (this.isEmpty()) {
            return 0;
        }
        int lastUsedIndex = this.buffer.position() - 1;
        return 8 * lastUsedIndex + (8 - BufferBitSet.numberOfLeadingZeros(this.byt(lastUsedIndex)));
    }

    public int size() {
        return this.buffer.limit() * 8;
    }

    public boolean isEmpty() {
        return this.buffer.position() == 0;
    }

    public int cardinality() {
        int position = this.buffer.position();
        int count = 0;
        for (int i = 0; i < position; ++i) {
            count += Integer.bitCount(this.byt(i) & 0xFF);
        }
        return count;
    }

    public int cardinality(int fromIndex, int toIndex) {
        BufferBitSet.checkRange(fromIndex, toIndex);
        int len = this.length();
        if (len <= fromIndex || fromIndex == toIndex) {
            return 0;
        }
        if (toIndex > len) {
            toIndex = len;
        }
        int startByteIndex = BufferBitSet.byteIndex(fromIndex);
        int endByteIndex = BufferBitSet.byteIndex(toIndex - 1);
        int firstByteMask = 255 << (fromIndex & 7) & 0xFF;
        int lastByteMask = 255 >>> (-toIndex & 7);
        if (startByteIndex == endByteIndex) {
            return Integer.bitCount(this.byt(startByteIndex) & (firstByteMask & lastByteMask));
        }
        int count = 0;
        count += Integer.bitCount(this.byt(startByteIndex) & firstByteMask);
        for (int i = startByteIndex + 1; i < endByteIndex; ++i) {
            count += Integer.bitCount(this.byt(i) & 0xFF);
        }
        return count += Integer.bitCount(this.byt(endByteIndex) & lastByteMask);
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        int position = this.buffer.position();
        int result = 1;
        for (int i = 0; i < position; ++i) {
            result = 31 * result + this.byt(i);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BufferBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        BufferBitSet set = (BufferBitSet)obj;
        int position = this.buffer.position();
        if (position != set.buffer.position()) {
            return false;
        }
        for (int i = 0; i < position; ++i) {
            if (this.byt(i) == set.byt(i)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        return this.copy();
    }

    public BufferBitSet copy() {
        ByteBuffer copy = BufferUtils.copy(this.buffer, 0, this.buffer.position());
        copy.position(this.buffer.position());
        return new BufferBitSet(copy, this.resizable, false);
    }

    private void expandTo(int byteIndex) {
        if (byteIndex >= this.buffer.limit()) {
            if (!this.resizable) {
                throw new IndexOutOfBoundsException("could not resize to accomodate byte index: " + byteIndex);
            }
            int capacity = Math.max(this.buffer.limit() * 2, byteIndex + 1);
            ByteBuffer buffer = BufferUtils.allocate(capacity);
            this.buffer.flip();
            this.buffer = buffer.put(this.buffer);
        }
        if (byteIndex >= this.buffer.position()) {
            this.buffer.position(byteIndex + 1);
        }
    }

    private void recalculateBytesInUse() {
        int n;
        for (n = this.buffer.position() - 1; n >= 0 && this.byt(n) == 0; --n) {
        }
        this.buffer.position(n + 1);
    }

    private void copyRemainingBytes(int bytesInCommon, BufferBitSet set) {
        if (bytesInCommon < set.buffer.position()) {
            this.expandTo(set.buffer.position() - 1);
            this.buffer.position(bytesInCommon);
            this.buffer.put(BufferUtils.slice(set.buffer, bytesInCommon, set.buffer.position()));
        }
    }

    private static int byteIndex(int bitIndex) {
        return bitIndex >> 3;
    }

    private static int bit(int bitIndex) {
        return 1 << (bitIndex & 7);
    }

    private byte byt(int byteIndex) {
        return this.buffer.get(byteIndex);
    }

    private void put(int byteIndex, int b) {
        this.buffer.put(byteIndex, (byte)b);
    }

    private static void checkRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    private static int numberOfLeadingZeros(byte b) {
        return Integer.numberOfLeadingZeros(b & 0xFF) & 7;
    }
}

