/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import tech.bitey.bufferstuff.BufferUtils;

public class BufferSort {
    private static final int INT_HIGH_BIT = Integer.MIN_VALUE;
    private static final long LONG_HIGH_BIT = Long.MIN_VALUE;
    private static final int SMALL_RANGE = 100;
    private static final int LARGE_RANGE = 10000000;

    public static void heapSort(IntBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(IntBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(IntBuffer b, int i, int j) {
        int swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void heapSort(LongBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(LongBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(LongBuffer b, int i, int j) {
        long swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void heapSort(ShortBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(ShortBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(ShortBuffer b, int i, int j) {
        short swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void heapSort(ByteBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(ByteBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && b.get(l) > b.get(largest)) {
            largest = l;
        }
        if (r < n && b.get(r) > b.get(largest)) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(ByteBuffer b, int i, int j) {
        byte swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void heapSort(FloatBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(FloatBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && Float.compare(b.get(l), b.get(largest)) > 0) {
            largest = l;
        }
        if (r < n && Float.compare(b.get(r), b.get(largest)) > 0) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(FloatBuffer b, int i, int j) {
        float swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void heapSort(DoubleBuffer b, int fromIndex, int toIndex) {
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int n = toIndex - fromIndex;
        if (n <= 1) {
            return;
        }
        for (i = fromIndex + n / 2 - 1; i >= fromIndex; --i) {
            BufferSort.heapify(b, toIndex, i, fromIndex);
        }
        for (i = toIndex - 1; i >= fromIndex; --i) {
            BufferSort.swap(b, fromIndex, i);
            BufferSort.heapify(b, i, fromIndex, fromIndex);
        }
    }

    private static void heapify(DoubleBuffer b, int n, int i, int offset) {
        int largest = i;
        int l = 2 * i + 1 - offset;
        int r = l + 1;
        if (l < n && Double.compare(b.get(l), b.get(largest)) > 0) {
            largest = l;
        }
        if (r < n && Double.compare(b.get(r), b.get(largest)) > 0) {
            largest = r;
        }
        if (largest != i) {
            BufferSort.swap(b, i, largest);
            BufferSort.heapify(b, n, largest, offset);
        }
    }

    private static void swap(DoubleBuffer b, int i, int j) {
        double swap = b.get(i);
        b.put(i, b.get(j));
        b.put(j, swap);
    }

    public static void radixSort(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.radixSort0(b, fromIndex, toIndex, Integer.MIN_VALUE);
    }

    private static void radixSort0(IntBuffer b, int fromIndex, int toIndex, int bit) {
        int direction;
        int zero = fromIndex;
        int one = toIndex;
        int n = direction = bit == Integer.MIN_VALUE ? bit : 0;
        while (zero < one) {
            if ((b.get(zero) & bit) == direction) {
                ++zero;
                continue;
            }
            BufferSort.swap(b, zero, --one);
        }
        if (bit != 1) {
            if (fromIndex < zero) {
                BufferSort.radixSort0(b, fromIndex, zero, bit >>> 1);
            }
            if (one < toIndex) {
                BufferSort.radixSort0(b, one, toIndex, bit >>> 1);
            }
        }
    }

    public static void radixSort(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        BufferSort.radixSort0(b, fromIndex, toIndex, Long.MIN_VALUE);
    }

    private static void radixSort0(LongBuffer b, int fromIndex, int toIndex, long bit) {
        long direction;
        int zero = fromIndex;
        int one = toIndex;
        long l = direction = bit == Long.MIN_VALUE ? bit : 0L;
        while (zero < one) {
            if ((b.get(zero) & bit) == direction) {
                ++zero;
                continue;
            }
            BufferSort.swap(b, zero, --one);
        }
        if (bit != 1L) {
            if (fromIndex < zero) {
                BufferSort.radixSort0(b, fromIndex, zero, bit >>> 1);
            }
            if (one < toIndex) {
                BufferSort.radixSort0(b, one, toIndex, bit >>> 1);
            }
        }
    }

    public static void countingSort(ShortBuffer b, int fromIndex, int toIndex) {
        int j;
        short s;
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int[] counts = new int[65536];
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            int n = b.get(i2) & 0xFFFF;
            counts[n] = counts[n] + 1;
        }
        int k = fromIndex;
        for (i = 32768; i < counts.length; ++i) {
            s = (short)i;
            for (j = 0; j < counts[i]; ++j) {
                b.put(k++, s);
            }
        }
        for (i = 0; i <= Short.MAX_VALUE; ++i) {
            s = (short)i;
            for (j = 0; j < counts[i]; ++j) {
                b.put(k++, s);
            }
        }
    }

    public static void countingSort(ByteBuffer b, int fromIndex, int toIndex) {
        int j;
        byte s;
        int i;
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        int[] counts = new int[256];
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            int n = b.get(i2) & 0xFF;
            counts[n] = counts[n] + 1;
        }
        int k = fromIndex;
        for (i = 128; i < counts.length; ++i) {
            s = (byte)i;
            for (j = 0; j < counts[i]; ++j) {
                b.put(k++, s);
            }
        }
        for (i = 0; i <= 127; ++i) {
            s = (byte)i;
            for (j = 0; j < counts[i]; ++j) {
                b.put(k++, s);
            }
        }
    }

    public static void insertionSort(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int xj;
            int j;
            int x = b.get(i);
            for (j = i - 1; j >= fromIndex && (xj = b.get(j)) > x; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void insertionSort(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long xj;
            int j;
            long x = b.get(i);
            for (j = i - 1; j >= fromIndex && (xj = b.get(j)) > x; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void insertionSort(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short xj;
            int j;
            short x = b.get(i);
            for (j = i - 1; j >= fromIndex && (xj = b.get(j)) > x; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void insertionSort(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte xj;
            int j;
            byte x = b.get(i);
            for (j = i - 1; j >= fromIndex && (xj = b.get(j)) > x; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void insertionSort(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float xj;
            int j;
            float x = b.get(i);
            for (j = i - 1; j >= fromIndex && Float.compare(xj = b.get(j), x) > 0; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void insertionSort(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double xj;
            int j;
            double x = b.get(i);
            for (j = i - 1; j >= fromIndex && Double.compare(xj = b.get(j), x) > 0; --j) {
                b.put(j + 1, xj);
            }
            b.put(j + 1, x);
        }
    }

    public static void sort(IntBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else if (length < 10000000) {
            BufferSort.heapSort(b, fromIndex, toIndex);
        } else {
            BufferSort.radixSort(b, fromIndex, toIndex);
        }
    }

    public static void sort(LongBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else if (length < 10000000) {
            BufferSort.heapSort(b, fromIndex, toIndex);
        } else {
            BufferSort.radixSort(b, fromIndex, toIndex);
        }
    }

    public static void sort(ShortBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else if (length < 10000000) {
            BufferSort.heapSort(b, fromIndex, toIndex);
        } else {
            BufferSort.countingSort(b, fromIndex, toIndex);
        }
    }

    public static void sort(ByteBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else if (length < 100000) {
            BufferSort.heapSort(b, fromIndex, toIndex);
        } else {
            BufferSort.countingSort(b, fromIndex, toIndex);
        }
    }

    public static void sort(FloatBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else {
            BufferSort.heapSort(b, fromIndex, toIndex);
        }
    }

    public static void sort(DoubleBuffer b, int fromIndex, int toIndex) {
        int length = toIndex - fromIndex;
        if (length < 100) {
            BufferSort.insertionSort(b, fromIndex, toIndex);
        } else {
            BufferSort.heapSort(b, fromIndex, toIndex);
        }
    }
}

