/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public enum BufferUtils {

    private static final boolean DIRECT = "true".equalsIgnoreCase(System.getProperty("tech.bitey.allocateDirect"));
    public static final ByteBuffer EMPTY_BUFFER = BufferUtils.asReadOnlyBuffer(BufferUtils.allocate(0));

    public static ByteBuffer allocate(int capacity) {
        return BufferUtils.allocate(capacity, ByteOrder.nativeOrder());
    }

    public static ByteBuffer allocate(int capacity, ByteOrder order) {
        return (DIRECT ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity)).order(order);
    }

    public static ByteBuffer duplicate(ByteBuffer b) {
        return b.duplicate().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b) {
        return b.slice().order(b.order());
    }

    public static ByteBuffer asReadOnlyBuffer(ByteBuffer b) {
        return b.asReadOnlyBuffer().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        ByteBuffer dup = BufferUtils.duplicate(b);
        dup.limit(toIndex);
        dup.position(fromIndex);
        return BufferUtils.slice(dup);
    }

    public static boolean isSorted(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static ByteBuffer copy(ByteBuffer b, int fromIndex, int toIndex) {
        ByteBuffer slice = BufferUtils.slice(b, fromIndex, toIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(slice.capacity()) : ByteBuffer.allocate(slice.capacity());
        copy.order(b.order());
        copy.put(slice);
        copy.flip();
        return copy;
    }

    public static IntBuffer copy(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        IntBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        IntBuffer view = copy.asIntBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static LongBuffer copy(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        LongBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        LongBuffer view = copy.asLongBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static ShortBuffer copy(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        ShortBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 2) : ByteBuffer.allocate(dup.remaining() * 2);
        copy.order(b.order());
        ShortBuffer view = copy.asShortBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static FloatBuffer copy(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        FloatBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        FloatBuffer view = copy.asFloatBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static DoubleBuffer copy(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        DoubleBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        DoubleBuffer view = copy.asDoubleBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static int deduplicate(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        int prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        long prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        short prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        byte prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        float prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        double prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    static void rangeCheck(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex > bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") > " + bufferCapacity);
        }
    }

    static void rangeCheckInclusive(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex >= bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") >= " + bufferCapacity);
        }
    }
}

