/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.codingless.core.gateway.util.InstallEvnUtl;
import tech.codingless.core.gateway.util.StringUtil;

public class AccessKeyHelper {
    private static final String PREFIX_KEY = "tech.codingless.accesskey.";
    private static final String DEFAULT_MODULE = "*/*";
    public static AccessKey DEFAULT_ACCESS_KEY = new AccessKey();
    public static Object LOCK = new Object();
    public static ConcurrentHashMap<String, AccessKey> ACCESS_KEYS = null;
    private static boolean loadsuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessKey get(String key) {
        if (ACCESS_KEYS != null && loadsuccess) {
            return ACCESS_KEYS.containsKey(key) ? ACCESS_KEYS.get(key) : DEFAULT_ACCESS_KEY;
        }
        String string = key;
        synchronized (string) {
            if (ACCESS_KEYS == null) {
                ACCESS_KEYS = new ConcurrentHashMap();
                Map<String, String> map = InstallEvnUtl.getByPrefix(PREFIX_KEY);
                HashMap tmp = new HashMap();
                map.keySet().forEach(k -> {
                    String[] strs = k.substring(PREFIX_KEY.length()).split("[.]");
                    if (!tmp.containsKey(strs[0])) {
                        tmp.put(strs[0], new HashMap());
                    }
                    ((Map)tmp.get(strs[0])).put(strs[1], (String)map.get(k));
                });
                tmp.values().forEach(item -> {
                    String secret = (String)item.get("secret");
                    String modules = (String)item.get("modules");
                    String keyId = (String)item.get("key");
                    String company = (String)item.get("company");
                    if (StringUtil.hasEmpty(secret, modules, keyId, company)) {
                        return;
                    }
                    AccessKey accessKey = new AccessKey();
                    accessKey.setKey(keyId.trim());
                    accessKey.setSecret(secret.trim());
                    accessKey.setCompany(company.trim());
                    for (String module : modules.trim().split(",")) {
                        if (module.split("/").length != 3) continue;
                        String[] grant = module.split("/");
                        ModuleGrant moduleGrant = new ModuleGrant();
                        moduleGrant.setModule(grant[0]);
                        moduleGrant.setVersion(grant[1]);
                        moduleGrant.setReadable(grant[2].toLowerCase().contains("r"));
                        moduleGrant.setWriteable(grant[2].toLowerCase().contains("w"));
                        accessKey.getModules().put(grant[0] + "/" + grant[1], moduleGrant);
                    }
                    ACCESS_KEYS.put(accessKey.getKey(), accessKey);
                });
                loadsuccess = true;
            }
        }
        return ACCESS_KEYS.containsKey(key) ? ACCESS_KEYS.get(key) : DEFAULT_ACCESS_KEY;
    }

    public static class ModuleGrant {
        private String module;
        private String version;
        private boolean readable;
        private boolean writeable;

        public String getModule() {
            return this.module;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public boolean isWriteable() {
            return this.writeable;
        }

        public void setModule(String module) {
            this.module = module;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }

        public void setWriteable(boolean writeable) {
            this.writeable = writeable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleGrant)) {
                return false;
            }
            ModuleGrant other = (ModuleGrant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isReadable() != other.isReadable()) {
                return false;
            }
            if (this.isWriteable() != other.isWriteable()) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleGrant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isReadable() ? 79 : 97);
            result = result * 59 + (this.isWriteable() ? 79 : 97);
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "AccessKeyHelper.ModuleGrant(module=" + this.getModule() + ", version=" + this.getVersion() + ", readable=" + this.isReadable() + ", writeable=" + this.isWriteable() + ")";
        }
    }

    public static class AccessKey {
        private String secret;
        private String key;
        private String company;
        public Map<String, ModuleGrant> modules = new HashMap<String, ModuleGrant>();

        public boolean isReadAble(String moduleAndversion) {
            if (this.modules.containsKey(moduleAndversion)) {
                return this.modules.get(moduleAndversion).isReadable();
            }
            if (this.modules.containsKey(AccessKeyHelper.DEFAULT_MODULE)) {
                return this.modules.get(AccessKeyHelper.DEFAULT_MODULE).isReadable();
            }
            return false;
        }

        public boolean isWriteAble(String moduleAndversion) {
            if (this.modules.containsKey(moduleAndversion)) {
                return this.modules.get(moduleAndversion).isWriteable();
            }
            if (this.modules.containsKey(AccessKeyHelper.DEFAULT_MODULE)) {
                return this.modules.get(AccessKeyHelper.DEFAULT_MODULE).isWriteable();
            }
            return false;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getKey() {
            return this.key;
        }

        public String getCompany() {
            return this.company;
        }

        public Map<String, ModuleGrant> getModules() {
            return this.modules;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCompany(String company) {
            this.company = company;
        }

        public void setModules(Map<String, ModuleGrant> modules) {
            this.modules = modules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccessKey)) {
                return false;
            }
            AccessKey other = (AccessKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$company = this.getCompany();
            String other$company = other.getCompany();
            if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
                return false;
            }
            Map<String, ModuleGrant> this$modules = this.getModules();
            Map<String, ModuleGrant> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AccessKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $company = this.getCompany();
            result = result * 59 + ($company == null ? 43 : $company.hashCode());
            Map<String, ModuleGrant> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        public String toString() {
            return "AccessKeyHelper.AccessKey(secret=" + this.getSecret() + ", key=" + this.getKey() + ", company=" + this.getCompany() + ", modules=" + this.getModules() + ")";
        }
    }
}

