/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import tech.codingless.core.gateway.annotation.GrantModuleCondition;
import tech.codingless.core.gateway.annotation.MyBiz;
import tech.codingless.core.gateway.annotation.MySignAuth;
import tech.codingless.core.gateway.annotation.MyTokenAuth;
import tech.codingless.core.gateway.data.MyMemoryAnalysisFlag;
import tech.codingless.core.gateway.helper.AccessKeyHelper;
import tech.codingless.core.gateway.helper.RequestMonitorHelper;
import tech.codingless.core.gateway.interceptor.BodyReaderHttpServletRequestWrapper;
import tech.codingless.core.gateway.service.AuthService;
import tech.codingless.core.gateway.util.DateUtil;
import tech.codingless.core.gateway.util.SHAUtil;
import tech.codingless.core.gateway.util.SessionUtil;
import tech.codingless.core.gateway.util.SignUtil;
import tech.codingless.core.gateway.util.StringUtil;

public class GatewayInterceptor
implements AsyncHandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GatewayInterceptor.class);
    private static final String ACCESS_KEY = "Access-Key";
    private static final String ACCESS_TIMESTAMP = "Access-Timestamp";
    private static final String ACCESS_SIGN = "Access-Sign";
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String DEFAULT_MODULE = "00000";
    private static final String ACCESS_TOKEN = "Access-Token";
    private static final ThreadLocal<MyMemoryAnalysisFlag> flag = new ThreadLocal();
    private static final ThreadLocal<Long> t = new ThreadLocal();
    private static final ThreadLocal<Boolean> DISABLE_LOG = new ThreadLocal();
    private static final ThreadLocal<Boolean> DISABLE_RESPONSE_LOG = new ThreadLocal();
    private static final ThreadLocal<String> REQUEST_BODY = new ThreadLocal();
    @Autowired(required=false)
    private AuthService authService;
    private static final ConcurrentHashMap<String, String> URI_CATCH = new ConcurrentHashMap();

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        block31: {
            block35: {
                MyTokenAuth myTokenAuth;
                HandlerMethod handlerMethod;
                block33: {
                    AuthService.TokenAuthResponse authResponse;
                    String moduleName;
                    block34: {
                        String token;
                        block32: {
                            block23: {
                                AccessKeyHelper.AccessKey accessKey;
                                block30: {
                                    Object signData;
                                    String accessSign;
                                    block29: {
                                        MySignAuth mySignAuth;
                                        block28: {
                                            block27: {
                                                String accessKeyStr;
                                                block25: {
                                                    AuthService.SignAuthResponse authResponse2;
                                                    block26: {
                                                        String accessTimeStamp;
                                                        block24: {
                                                            block22: {
                                                                if (handler instanceof HandlerMethod) break block22;
                                                                boolean bl = super.preHandle(request, response, handler);
                                                                return bl;
                                                            }
                                                            this.clearSession();
                                                            t.set(System.currentTimeMillis());
                                                            handlerMethod = (HandlerMethod)handler;
                                                            MyBiz myBiz = (MyBiz)handlerMethod.getMethodAnnotation(MyBiz.class);
                                                            if (myBiz != null) {
                                                                DISABLE_LOG.set(myBiz.disableRequestLog());
                                                                DISABLE_RESPONSE_LOG.set(myBiz.disableResponseLog());
                                                            }
                                                            moduleName = GrantModuleCondition.findModuleNameByResourcePkg(handlerMethod.getBean().getClass());
                                                            REQUEST_BODY.remove();
                                                            if (handlerMethod.getMethodAnnotation(MySignAuth.class) == null) break block23;
                                                            mySignAuth = (MySignAuth)handlerMethod.getMethodAnnotation(MySignAuth.class);
                                                            accessKeyStr = request.getHeader(ACCESS_KEY);
                                                            if (!StringUtil.hasEmpty(accessKeyStr, accessTimeStamp = request.getHeader(ACCESS_TIMESTAMP), accessSign = request.getHeader(ACCESS_SIGN))) break block24;
                                                            this.notAuthResponse(request, response, handlerMethod);
                                                            boolean bl = false;
                                                            return bl;
                                                        }
                                                        signData = null;
                                                        if ("GET".equalsIgnoreCase(request.getMethod())) {
                                                            TreeMap<String, String> singParam = new TreeMap<String, String>();
                                                            request.getParameterNames().asIterator().forEachRemaining(paramName -> singParam.put((String)paramName, request.getParameter(paramName)));
                                                            signData = SignUtil.toSignSrc(singParam, accessTimeStamp);
                                                        } else if ("application/json".equalsIgnoreCase(request.getContentType()) && request instanceof BodyReaderHttpServletRequestWrapper) {
                                                            BodyReaderHttpServletRequestWrapper wrapper = (BodyReaderHttpServletRequestWrapper)request;
                                                            String requestBody = wrapper.getRequestBody();
                                                            REQUEST_BODY.set(requestBody);
                                                            signData = requestBody + "&" + accessTimeStamp;
                                                        }
                                                        if (this.authService == null) break block25;
                                                        AuthService.SignAuthRequest authRequest = new AuthService.SignAuthRequest();
                                                        authRequest.setIp(request.getHeader(X_REAL_IP));
                                                        authRequest.setUri(request.getRequestURI());
                                                        authRequest.setSign(accessSign);
                                                        authRequest.setSignKey(accessKeyStr);
                                                        authRequest.setSignTimestamp(accessTimeStamp);
                                                        authRequest.setSignData((String)signData);
                                                        authResponse2 = this.authService.signAuth(authRequest);
                                                        if (authResponse2.isAllowed()) break block26;
                                                        this.notAuthResponse(request, response, handlerMethod);
                                                        boolean bl = false;
                                                        return bl;
                                                    }
                                                    this.setRequestLog(moduleName, request, response);
                                                    MySignAuth.CURRENT_COMPANY_ID.set(authResponse2.getCompanyId());
                                                    MySignAuth.ACCESS_KEY.set(authResponse2.getSignKey());
                                                    SessionUtil.CURRENT_COMPANY_ID.set(authResponse2.getCompanyId());
                                                    SessionUtil.CURRENT_USER_ID.set(authResponse2.getSignKey());
                                                    boolean bl = super.preHandle(request, response, handler);
                                                    return bl;
                                                }
                                                accessKey = AccessKeyHelper.get(accessKeyStr.trim());
                                                if (!StringUtil.isEmpty(moduleName)) break block27;
                                                this.notAuthResponse(request, response, handlerMethod);
                                                boolean authResponse2 = false;
                                                return authResponse2;
                                            }
                                            if (accessKey.isReadAble(moduleName) || accessKey.isWriteAble(moduleName)) break block28;
                                            this.notAuthResponse(request, response, handlerMethod);
                                            boolean authResponse2 = false;
                                            return authResponse2;
                                        }
                                        if (!mySignAuth.requiredWriteAble() || !BooleanUtils.isFalse((Boolean)accessKey.isWriteAble(moduleName))) break block29;
                                        this.notAuthResponse(request, response, handlerMethod);
                                        boolean authResponse2 = false;
                                        return authResponse2;
                                    }
                                    boolean signVerify = SHAUtil.verifySign(accessKey.getSecret(), (String)signData, accessSign);
                                    if (signVerify) break block30;
                                    this.notAuthResponse(request, response, handlerMethod);
                                    boolean bl = false;
                                    return bl;
                                }
                                this.setRequestLog(moduleName, request, response);
                                MySignAuth.CURRENT_COMPANY_ID.set(accessKey.getCompany());
                                MySignAuth.ACCESS_KEY.set(accessKey.getKey());
                                SessionUtil.CURRENT_COMPANY_ID.set(accessKey.getCompany());
                                SessionUtil.CURRENT_USER_ID.set(accessKey.getKey());
                                boolean bl = super.preHandle(request, response, handler);
                                return bl;
                            }
                            if (handlerMethod.getMethodAnnotation(MyTokenAuth.class) == null) break block31;
                            myTokenAuth = (MyTokenAuth)handlerMethod.getMethodAnnotation(MyTokenAuth.class);
                            token = request.getHeader(ACCESS_TOKEN);
                            if (!myTokenAuth.required() || !StringUtil.isEmpty(token)) break block32;
                            this.notAuthResponse(request, response, handlerMethod);
                            boolean accessTimeStamp = false;
                            return accessTimeStamp;
                        }
                        if (this.authService == null) break block33;
                        AuthService.TokenAuthRequest authRequest = new AuthService.TokenAuthRequest();
                        authRequest.setIp(request.getHeader(X_REAL_IP));
                        authRequest.setUri(request.getRequestURI());
                        authRequest.setToken(token);
                        authResponse = this.authService.tokenAuth(authRequest);
                        if (!myTokenAuth.required() || authResponse.isAllowed()) break block34;
                        this.notAuthResponse(request, response, handlerMethod);
                        boolean bl = false;
                        return bl;
                    }
                    this.setRequestLog(moduleName, request, response);
                    SessionUtil.CURRENT_COMPANY_ID.set(authResponse.getCompanyId());
                    SessionUtil.CURRENT_USER_ID.set(authResponse.getUserId());
                    SessionUtil.CURRENT_USER_NAME.set(authResponse.getUserName());
                    boolean bl = super.preHandle(request, response, handler);
                    return bl;
                }
                if (!myTokenAuth.required()) break block35;
                this.notAuthResponse(request, response, handlerMethod);
                boolean bl = false;
                return bl;
            }
            boolean bl = super.preHandle(request, response, handler);
            return bl;
        }
        try {
            this.setRequestLog(DEFAULT_MODULE, request, response);
            boolean bl = super.preHandle(request, response, handler);
            return bl;
        }
        catch (Throwable e) {
            log.error("error", e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notAuthResponse(HttpServletRequest request, HttpServletResponse response, HandlerMethod handlerMethod) throws IOException {
        try {
            response.setHeader("Unauthorized", "1");
            response.sendError(401);
            SessionUtil.CURRENT_RESPONSE.set("Unauthorized");
            this.appendLog(request, response, handlerMethod, null);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.clearSession();
        }
    }

    private void appendLog(HttpServletRequest request, HttpServletResponse response, Object handlerMethod, Exception ex) throws IOException {
        if (BooleanUtils.isTrue((Boolean)DISABLE_LOG.get())) {
            return;
        }
        String uri = this.getUri(request, handlerMethod);
        String urlParam = request.getParameterMap().isEmpty() ? null : JSON.toJSONString((Object)request.getParameterMap());
        long cost = System.currentTimeMillis() - t.get();
        JSONObject req = new JSONObject();
        req.put((Object)"ip", (Object)request.getHeader(X_REAL_IP));
        req.put((Object)"t", (Object)System.currentTimeMillis());
        req.put((Object)"method", (Object)request.getMethod());
        req.put((Object)"companyId", (Object)MySignAuth.CURRENT_COMPANY_ID.get());
        req.put((Object)"access_key", (Object)MySignAuth.ACCESS_KEY.get());
        req.put((Object)"cost", (Object)cost);
        req.put((Object)"uri", (Object)uri);
        req.put((Object)"url", (Object)request.getRequestURL().toString());
        req.put((Object)"url_param", (Object)urlParam);
        if ("POST".equalsIgnoreCase(request.getMethod()) && "application/json".equalsIgnoreCase(request.getContentType()) && request instanceof BodyReaderHttpServletRequestWrapper) {
            req.put((Object)"req_body", (Object)REQUEST_BODY.get());
        }
        if (BooleanUtils.isNotTrue((Boolean)DISABLE_RESPONSE_LOG.get())) {
            req.put((Object)"response", (Object)SessionUtil.CURRENT_RESPONSE.get());
        }
        StringBuilder str = new StringBuilder();
        str.append("REQUEST_INFO:").append(req);
        log.info(str.toString());
        RequestMonitorHelper.append(SessionUtil.CURRENT_COMPANY_ID.get(), SessionUtil.CURRENT_USER_ID.get(), SessionUtil.CURRENT_USER_NAME.get(), SessionUtil.RID.get(), uri, request.getRequestURL().toString(), cost, urlParam, REQUEST_BODY.get(), BooleanUtils.isNotTrue((Boolean)DISABLE_RESPONSE_LOG.get()) ? SessionUtil.CURRENT_RESPONSE.get() : null, ex);
    }

    private void setRequestLog(String moduleName, HttpServletRequest request, HttpServletResponse response) {
        String requestId = DateUtil.formatYYYYMMDD(new Date()) + "-REQ-" + moduleName.replace("/", "").toUpperCase() + "-" + StringUtil.genGUID() + "-" + StringUtil.genShortGUID().toLowerCase();
        response.addHeader("Request-Id", requestId);
        SessionUtil.RID.set(requestId);
        MyMemoryAnalysisFlag maf = new MyMemoryAnalysisFlag("REQ:" + request.getRequestURL().toString(), requestId);
        maf.setReqBody(REQUEST_BODY.get());
        if (!request.getParameterMap().isEmpty()) {
            maf.setUrlParam(JSON.toJSONString((Object)request.getParameterMap()));
        }
        flag.set(maf);
        RequestMonitorHelper.append(maf);
    }

    private void clearSession() {
        RequestMonitorHelper.clear(flag.get());
        flag.remove();
        MySignAuth.CURRENT_COMPANY_ID.remove();
        MySignAuth.ACCESS_KEY.remove();
        REQUEST_BODY.remove();
        SessionUtil.CURRENT_COMPANY_ID.remove();
        SessionUtil.CURRENT_USER_ID.remove();
        DISABLE_LOG.remove();
        SessionUtil.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        try {
            this.appendLog(request, response, handler, ex);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.clearSession();
        }
        super.afterCompletion(request, response, handler, ex);
    }

    private String getUri(HttpServletRequest request, Object handler) {
        if (URI_CATCH.containsKey(handler.toString())) {
            return URI_CATCH.get(handler.toString());
        }
        StringBuilder uri = new StringBuilder();
        if (handler instanceof HandlerMethod) {
            GetMapping getMapping;
            HandlerMethod method = (HandlerMethod)handler;
            RequestMapping reqMapping = method.getBeanType().getAnnotation(RequestMapping.class);
            if (reqMapping != null) {
                uri.append(reqMapping.value()[0]);
            }
            if ((getMapping = (GetMapping)method.getMethodAnnotation(GetMapping.class)) != null) {
                uri.append(getMapping.value()[0]);
            } else if (method.getMethodAnnotation(PostMapping.class) != null) {
                uri.append(((PostMapping)method.getMethodAnnotation(PostMapping.class)).value()[0]);
            } else if (method.getMethodAnnotation(PutMapping.class) != null) {
                uri.append(((PutMapping)method.getMethodAnnotation(PutMapping.class)).value()[0]);
            } else if (method.getMethodAnnotation(DeleteMapping.class) != null) {
                uri.append(((DeleteMapping)method.getMethodAnnotation(DeleteMapping.class)).value()[0]);
            } else {
                uri.append(request.getRequestURI());
            }
        }
        URI_CATCH.put(handler.toString(), uri.toString());
        return uri.toString();
    }
}

