/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.util;

import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    private static final String EMPTY_STR = "";
    private static final String AES = "AES";
    private static final String UTF8 = "utf-8";
    private static final String SHA1PRNG = "SHA1PRNG";
    private static final String AES_ECB_PKCS5Padding = "AES/ECB/PKCS5Padding";

    public static String genNewSecret(KeyLen keyLen, String salt) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            SecureRandom secureRandom = SecureRandom.getInstance(SHA1PRNG);
            secureRandom.setSeed(salt.getBytes());
            kgen.init(keyLen.len, new SecureRandom(salt.getBytes()));
            SecretKey key = kgen.generateKey();
            return new String(Base64.encodeBase64((byte[])key.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_STR;
        }
    }

    public static String genNewSecret(String salt) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            SecureRandom secureRandom = SecureRandom.getInstance(SHA1PRNG);
            secureRandom.setSeed(salt.getBytes());
            kgen.init(128, new SecureRandom(salt.getBytes()));
            SecretKey key = kgen.generateKey();
            return new String(Base64.encodeBase64((byte[])key.getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_STR;
        }
    }

    public static String encrypt(String base64Secret, String data) {
        try {
            byte[] secret = Base64.decodeBase64((String)base64Secret);
            Cipher cipher = Cipher.getInstance(AES_ECB_PKCS5Padding);
            SecretKeySpec key = new SecretKeySpec(secret, AES);
            cipher.init(1, key);
            return Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes(UTF8)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_STR;
        }
    }

    public static String decrypt(String base64Secret, String data) {
        try {
            byte[] secret = Base64.decodeBase64((String)base64Secret);
            Cipher cipher = Cipher.getInstance(AES_ECB_PKCS5Padding);
            SecretKeySpec key = new SecretKeySpec(secret, AES);
            cipher.init(2, key);
            return new String(cipher.doFinal(Base64.decodeBase64((String)data)), UTF8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_STR;
        }
    }

    public static void main(String[] args) throws Exception {
        String str = "\u5728\u592a\u9633\u7cfb\uff0c\u516b\u5927\u884c\u661f\u4ee5\u592a\u9633\u4e3a\u6838\u5fc3\u516c\u8f6c\uff0c\u5f62\u6210\u4e868\u4e2a\u73af\u5f62\u8f68\u9053\uff0c\u5176\u4e2d\u5730\u7403\u4f4d\u4e8e\u201c\u4e09\u73af\u201d\uff0c\u706b\u661f\u5219\u5728\u201c\u56db\u73af\u201d\u8fd0\u884c\u3002\u5929\u95ee\u4e00\u53f7\u63a2\u6d4b\u5668\u8981\u60f3\u51b2\u51fa\u5730\u7403\u62b5\u8fbe\u706b\u661f\uff0c\u7edd\u4e0d\u662f\u7b80\u5355\u5730\u4ece\u201c\u4e09\u73af\u201d\u8de8\u8d8a\u5230\u201c\u56db\u73af\u201d\uff0c\u800c\u662f\u957f\u9014\u8dcb\u6d89\u51e0\u4e2a\u6708\uff0c\u76f4\u7ebf\u8ddd\u79bb\u7a81\u78344\u4ebf\u516c\u91cc\u7684\u65c5\u7a0b\u3002";
        System.out.println(AESUtil.genNewSecret("oCaTdqMAfJHXm"));
        System.out.println(AESUtil.genNewSecret("123"));
        String key = "oCaTdqMAfJHXm/z6uHf9qw==";
        System.out.println(AESUtil.encrypt(key, str));
        System.out.println(AESUtil.decrypt(key, AESUtil.encrypt(key, str)));
        JSONObject json = new JSONObject();
        json.put("buyerName", (Object)"Hello ,Wang");
        System.out.println(AESUtil.encrypt("EZfpOga2+q2kINgk6Wo2OQ==", json.toJSONString()));
        System.out.println(AESUtil.encrypt("EZfpOga2+q2kINgk6Wo2OQ==", "1"));
    }

    public static enum KeyLen {
        LEN_128(128),
        LEN_192(192),
        LEN_256(256);

        private int len;

        private KeyLen(int len) {
            this.len = len;
        }

        public int getLen() {
            return this.len;
        }
    }
}

