/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.gateway.util;

import java.util.concurrent.ConcurrentHashMap;
import tech.codingless.core.gateway.util.StringUtil;

public class ModuleUtil {
    private static final String GRANT_PREFIX = "tech.codingless.biz.module.";
    private static final String versionRegex = ".v[0-9].";
    private static final ConcurrentHashMap<Class<?>, ModuleInfo> CACHE = new ConcurrentHashMap();
    private static ModuleInfo NONE = new ModuleInfo();

    public static ModuleInfo pickModuleInfoFromClassName(String fullClassName) {
        ModuleInfo info = new ModuleInfo();
        info.setModuleCode("NONE");
        info.setModuleVersion("v1");
        info.setResource(fullClassName);
        String subStr = fullClassName.substring(GRANT_PREFIX.length());
        String[] codes = subStr.split(versionRegex, 2);
        if (codes.length != 2) {
            return info;
        }
        String ver = StringUtil.findOne(subStr, versionRegex).replace(".", "");
        info.setModuleCode(codes[0]);
        info.setModuleVersion(ver);
        info.setResource(fullClassName);
        info.setModuleCodeAndVersion(info.getModuleCode() + "/" + info.getModuleVersion());
        return info;
    }

    public static ModuleInfo pickModuleInfo(Class<? extends Object> clazz) {
        if (CACHE.containsKey(clazz)) {
            return CACHE.get(clazz);
        }
        if (!clazz.getName().startsWith(GRANT_PREFIX)) {
            return NONE;
        }
        ModuleInfo moduleInfo = ModuleUtil.pickModuleInfoFromClassName(clazz.getName());
        CACHE.put(clazz, moduleInfo);
        return moduleInfo;
    }

    static {
        NONE.setModuleCode("*");
        NONE.setModuleVersion("*");
        NONE.setResource("*");
        NONE.setModuleCodeAndVersion("*/*");
    }

    public static class ModuleInfo {
        private String moduleCode;
        private String moduleVersion;
        private String resource;
        private String moduleCodeAndVersion;

        public String getModuleCode() {
            return this.moduleCode;
        }

        public String getModuleVersion() {
            return this.moduleVersion;
        }

        public String getResource() {
            return this.resource;
        }

        public String getModuleCodeAndVersion() {
            return this.moduleCodeAndVersion;
        }

        public void setModuleCode(String moduleCode) {
            this.moduleCode = moduleCode;
        }

        public void setModuleVersion(String moduleVersion) {
            this.moduleVersion = moduleVersion;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public void setModuleCodeAndVersion(String moduleCodeAndVersion) {
            this.moduleCodeAndVersion = moduleCodeAndVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleInfo)) {
                return false;
            }
            ModuleInfo other = (ModuleInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$moduleCode = this.getModuleCode();
            String other$moduleCode = other.getModuleCode();
            if (this$moduleCode == null ? other$moduleCode != null : !this$moduleCode.equals(other$moduleCode)) {
                return false;
            }
            String this$moduleVersion = this.getModuleVersion();
            String other$moduleVersion = other.getModuleVersion();
            if (this$moduleVersion == null ? other$moduleVersion != null : !this$moduleVersion.equals(other$moduleVersion)) {
                return false;
            }
            String this$resource = this.getResource();
            String other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            String this$moduleCodeAndVersion = this.getModuleCodeAndVersion();
            String other$moduleCodeAndVersion = other.getModuleCodeAndVersion();
            return !(this$moduleCodeAndVersion == null ? other$moduleCodeAndVersion != null : !this$moduleCodeAndVersion.equals(other$moduleCodeAndVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $moduleCode = this.getModuleCode();
            result = result * 59 + ($moduleCode == null ? 43 : $moduleCode.hashCode());
            String $moduleVersion = this.getModuleVersion();
            result = result * 59 + ($moduleVersion == null ? 43 : $moduleVersion.hashCode());
            String $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            String $moduleCodeAndVersion = this.getModuleCodeAndVersion();
            result = result * 59 + ($moduleCodeAndVersion == null ? 43 : $moduleCodeAndVersion.hashCode());
            return result;
        }

        public String toString() {
            return "ModuleUtil.ModuleInfo(moduleCode=" + this.getModuleCode() + ", moduleVersion=" + this.getModuleVersion() + ", resource=" + this.getResource() + ", moduleCodeAndVersion=" + this.getModuleCodeAndVersion() + ")";
        }
    }
}

