/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import com.alibaba.fastjson2.JSON;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tech.codingless.core.plugs.mybaties3.DBBaseGenericService;
import tech.codingless.core.plugs.mybaties3.GenericQueryDao;
import tech.codingless.core.plugs.mybaties3.GenericUpdateDao;
import tech.codingless.core.plugs.mybaties3.SerializableFunction;
import tech.codingless.core.plugs.mybaties3.annotation.OrderTypeEnum;
import tech.codingless.core.plugs.mybaties3.condition.ColumnSelector;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionWrapper;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.data.PageRollResult;
import tech.codingless.core.plugs.mybaties3.data.UpdateObject;
import tech.codingless.core.plugs.mybaties3.helper.ColumnHelper;
import tech.codingless.core.plugs.mybaties3.strategy.IdCreator;
import tech.codingless.core.plugs.mybaties3.util.DataEnvUtil;
import tech.codingless.core.plugs.mybaties3.util.DataSessionEnv;
import tech.codingless.core.plugs.mybaties3.util.MybatiesAssertUtil;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class DBBaseGenericServiceImpl<T extends BaseDO>
implements DBBaseGenericService<T> {
    @Autowired
    protected GenericUpdateDao<T> updateDao;
    @Autowired
    protected GenericQueryDao<T> queryDao;
    @Autowired
    protected GenericQueryDao queryGenericDao;
    @Autowired(required=false)
    protected IdCreator idcreator;
    private String namespace;

    private void generateId(T data) {
        String newId;
        if (this.idcreator != null && MybatiesStringUtil.isNotEmpty(newId = this.idcreator.generateId((BaseDO)data))) {
            ((BaseDO)data).setId(newId);
            return;
        }
        ObjectId objectId = new ObjectId();
        ((BaseDO)data).setId(objectId.toHexString());
    }

    protected String namespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        Type type = this.getClass().getGenericSuperclass();
        Type trueType = ((ParameterizedType)type).getActualTypeArguments()[0];
        this.namespace = trueType.getTypeName() + ".";
        return this.namespace;
    }

    @Override
    @Transactional
    public boolean create(T data) {
        ((BaseDO)data).setDel(false);
        ((BaseDO)data).setEnv(DataEnvUtil.getEvn());
        if (MybatiesStringUtil.isEmpty(((BaseDO)data).getId())) {
            this.generateId(data);
        }
        if (MybatiesStringUtil.isEmpty(((BaseDO)data).getCreateUid())) {
            ((BaseDO)data).setCreateUid(DataSessionEnv.CURRENT_USER_ID.get());
        }
        if (MybatiesStringUtil.isEmpty(((BaseDO)data).getOwnerId())) {
            ((BaseDO)data).setOwnerId(DataSessionEnv.CURRENT_USER_ID.get());
        }
        ((BaseDO)data).setWriteUid(MybatiesStringUtil.isNotEmpty(((BaseDO)data).getWriteUid()) ? ((BaseDO)data).getWriteUid() : DataSessionEnv.CURRENT_USER_ID.get());
        ((BaseDO)data).setCompanyId(MybatiesStringUtil.isNotEmpty(((BaseDO)data).getCompanyId()) ? ((BaseDO)data).getCompanyId() : DataSessionEnv.CURRENT_COMPANY_ID.get());
        ((BaseDO)data).setVer(((BaseDO)data).getVer() != null ? ((BaseDO)data).getVer() : 1L);
        return this.updateDao.createEntity(data) == 1;
    }

    @Override
    @Transactional
    public boolean create(String companyId, T obj) {
        MybatiesAssertUtil.assertNotEmpty(companyId, "COMPANY_ID_NOT_EXIST");
        T entiry = obj;
        ((BaseDO)entiry).setCompanyId(companyId);
        return this.create(obj);
    }

    @Override
    @Transactional
    public boolean update(T data) {
        if (DataSessionEnv.CURRENT_USER_ID.get() == null || !DataSessionEnv.CURRENT_USER_ID.get().equals(((BaseDO)data).getOwnerId())) {
            return false;
        }
        ((BaseDO)data).setWriteUid(DataSessionEnv.CURRENT_USER_ID.get());
        boolean success = this.updateDao.updateEntity((BaseDO)data) == 1;
        return success;
    }

    @Override
    @Transactional
    public boolean updateNotNull(String companyId, T data, Long ver) {
        MybatiesAssertUtil.assertNotEmpty(companyId, "COMPANY_ID_EMPTY");
        ((BaseDO)data).setCompanyId(companyId);
        return this.updateSkipNull(data, ver);
    }

    @Override
    @Transactional
    public boolean updateSkipNull(String companyId, T data, Long ver) {
        MybatiesAssertUtil.assertNotEmpty(companyId, "COMPANY_ID_EMPTY");
        ((BaseDO)data).setCompanyId(companyId);
        return this.updateSkipNull(data, ver);
    }

    @Override
    @Transactional
    public boolean updateSkipNull(T data, Long ver) {
        MybatiesAssertUtil.assertTrue(this.updateDao.updateNotNull(data, ver) == 1, "UPDATE_NOT_NULL_FAIL");
        return false;
    }

    @Override
    public int batchUpdateAppend(String companyId, T data, Long ver, int batchSize) {
        return this.updateDao.updateSkipNullBatchAppend(companyId, data, ver, batchSize);
    }

    @Override
    public int batchUpdateExecute(Class<T> clazz) {
        return this.updateDao.updateSkipNullBatchExecute(clazz);
    }

    @Override
    public int batchUpdate(List<UpdateObject> updateList) {
        return this.updateDao.updateSkipNullBatchExecute(updateList);
    }

    @Override
    @Transactional
    public boolean update(T data, String companyId) {
        ((BaseDO)data).setWriteUid(DataSessionEnv.CURRENT_USER_ID.get());
        return this.updateDao.updateEntityWithCompanyId((BaseDO)data, companyId) == 1;
    }

    @Override
    @Transactional
    public boolean updateSkipCheckOwner(T data) {
        ((BaseDO)data).setWriteUid(DataSessionEnv.CURRENT_USER_ID.get());
        return this.updateDao.updateEntity((BaseDO)data) == 1;
    }

    @Override
    @Transactional
    public boolean deletePhysical(Class<T> clazz, String id, String companyId) {
        return this.updateDao.deleteEntityWithCompanyId(clazz, id, companyId) == 1;
    }

    @Override
    @Transactional
    public boolean deleteLogical(Class<T> clazz, String id, String companyId) {
        return this.updateDao.deleteLogicalWithCompanyId(clazz, id, companyId) == 1;
    }

    @Override
    @Transactional
    public int deleteLogical(Class<T> clazz, Collection<String> idList, String companyId) {
        return this.updateDao.deleteLogicalWithCompanyId(clazz, idList, companyId);
    }

    @Override
    public List<T> list(Class<T> clazz) {
        return this.queryDao.list(clazz);
    }

    @Override
    public T get(Class<T> clazz, String entityId) {
        if (MybatiesStringUtil.isNotEmpty(DataSessionEnv.CURRENT_COMPANY_ID.get())) {
            return this.queryDao.getEntity(clazz, entityId);
        }
        return this.queryDao.getEntity(clazz, entityId);
    }

    @Override
    public T get(String id) {
        return this.get(this.getEntityClass(), id);
    }

    @Override
    public T get(Class<T> clazz, String id, String companyId) {
        T t = this.queryDao.getEntity(clazz, id, companyId);
        return t;
    }

    @Override
    public List<T> get(Class<T> clazz, String companyId, Collection<String> idList) {
        return this.queryDao.findEntityList(clazz, companyId, idList);
    }

    @Override
    public List<T> get(Class<T> clazz, String companyId, Collection<String> idList, Collection<String> columns) {
        if (!CollectionUtils.isEmpty(columns)) {
            MybatiesAssertUtil.assertTrue(columns.stream().filter(column -> ColumnHelper.isIncorrectColumn(column)).count() == 0L, "HAS_INCORRECT_COLUMN");
        }
        return this.queryDao.findEntityList(clazz, companyId, idList, columns);
    }

    @Override
    @Transactional
    public boolean create(List<T> list) {
        list.forEach(item -> {
            if (MybatiesStringUtil.isEmpty(item.getId())) {
                this.generateId(item);
            }
            item.setCreateUid(DataSessionEnv.CURRENT_USER_ID.get());
            item.setOwnerId(DataSessionEnv.CURRENT_USER_ID.get());
            item.setWriteUid(DataSessionEnv.CURRENT_USER_ID.get());
            item.setDel(false);
            if (MybatiesStringUtil.isEmpty(item.getCompanyId())) {
                item.setCompanyId(DataSessionEnv.CURRENT_COMPANY_ID.get());
            }
            if (item.getVer() == null) {
                item.setVer(1L);
            }
            item.setEnv(DataEnvUtil.getEvn());
        });
        return this.updateDao.createEntityList(list) == list.size();
    }

    @Override
    @Transactional
    public boolean create(String companyId, List<T> list) {
        list.forEach(item -> {
            item.setCompanyId(companyId);
            item.setEnv(DataEnvUtil.getEvn());
        });
        return this.create(list);
    }

    @Override
    @Transactional
    public List<T> list(Class<T> clazz, String companyId) {
        return this.queryDao.list(clazz, companyId);
    }

    @Override
    public PageRollResult<T> rollPage(Class<T> clazz, String companyId, T param, String orderColumn, OrderTypeEnum orderType, Integer size, Integer page) {
        return this.queryDao.rollPage(clazz, companyId, param, orderColumn, orderType, size, page);
    }

    @Override
    public PageRollResult<?> rollPage(String selectId, Map<String, Object> param, int size, int page) {
        return this.queryDao.rollPage(this.namespace(), selectId, param, size, page);
    }

    @Override
    public T findOneByExample(Class<T> clazz, String companyId, T example) {
        List<T> list = this.findByExample(clazz, companyId, example, 2);
        MybatiesAssertUtil.assertTrue(list == null || list.size() <= 1, "RESULT_MORE_THEN_ONE");
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return (T)((BaseDO)list.get(0));
    }

    @Override
    public List<T> findByExample(Class<T> clazz, String companyId, T example, Integer size) {
        PageRollResult<T> result = this.queryDao.rollPage(clazz, companyId, example, null, null, size, 1);
        return result.getList();
    }

    @Override
    public List<T> findByExample(Class<T> clazz, T example, Integer size) {
        PageRollResult<T> result = this.queryDao.rollPage(clazz, null, example, null, null, size, 1);
        return result.getList();
    }

    @Override
    public <E> List<E> noShardingList(String statement, Object parameter) {
        return this.queryGenericDao.noShardingList(statement, parameter);
    }

    @Override
    public String getEntityClassName() {
        Type type = this.getClass().getGenericSuperclass();
        Type trueType = ((ParameterizedType)type).getActualTypeArguments()[0];
        return trueType.getTypeName();
    }

    private Class<T> getEntityClass() {
        Type type = this.getClass().getGenericSuperclass();
        Type trueType = ((ParameterizedType)type).getActualTypeArguments()[0];
        return (Class)trueType;
    }

    @Override
    public T get(String id, String companyId) {
        return this.get(this.getEntityClass(), id, companyId);
    }

    @Override
    public List<T> get(String companyId, Collection<String> idList) {
        return this.get(this.getEntityClass(), companyId, idList);
    }

    @Override
    public List<T> get(String companyId, Collection<String> idList, Collection<String> columns) {
        return this.get(this.getEntityClass(), companyId, idList, columns);
    }

    @Override
    public boolean deletePhysical(String id, String companyId) {
        return this.deletePhysical(this.getEntityClass(), id, companyId);
    }

    @Override
    public boolean deleteLogical(String id, String companyId) {
        return this.deleteLogical(this.getEntityClass(), id, companyId);
    }

    @Override
    public int deleteLogical(Collection<String> idList, String companyId) {
        return this.deleteLogical(this.getEntityClass(), idList, companyId);
    }

    @Override
    public List<T> list() {
        return this.list(this.getEntityClass());
    }

    @Override
    public List<T> list(String companyId) {
        return this.list(this.getEntityClass(), companyId);
    }

    @Override
    public PageRollResult<T> rollPage(String companyId, T param, String orderColumn, OrderTypeEnum orderType, Integer size, Integer page) {
        return this.rollPage(this.getEntityClass(), companyId, param, orderColumn, orderType, size, page);
    }

    @Override
    public List<T> findByExample(String companyId, T example, Integer size) {
        return this.findByExample(this.getEntityClass(), companyId, example, size);
    }

    @Override
    public List<T> findByExample(T example, Integer size) {
        return this.findByExample(this.getEntityClass(), example, size);
    }

    @Override
    public T findOneByExample(String companyId, T example) {
        return this.findOneByExample(this.getEntityClass(), companyId, example);
    }

    @Override
    public List<Map<String, ?>> select(String selectId, Map<String, ?> param, int offset, int limit) {
        return this.queryGenericDao.select(selectId, param, offset, limit);
    }

    @Override
    public List<Map<String, ?>> select(String selectId, String param, int offset, int limit) {
        return this.queryGenericDao.select(selectId, MybatiesStringUtil.isEmpty(param) ? new HashMap<String, Object>() : JSON.parseObject((String)param), offset, limit);
    }

    @Override
    public List<T> select(ColumnSelector<T> columns, QueryConditionWrapper<T> wrapper, SerializableFunction<T, Object> orderColumn, OrderTypeEnum orderType, int offset, int limit) {
        wrapper.isFalse(BaseDO::isDel);
        wrapper.eq(BaseDO::getEnv, DataEnvUtil.getEvn());
        return this.queryGenericDao.select(this.getEntityClass(), columns, wrapper, orderColumn, orderType, offset, limit);
    }

    @Override
    public long count(QueryConditionWrapper<T> wrapper) {
        wrapper.isFalse(BaseDO::isDel);
        wrapper.eq(BaseDO::getEnv, DataEnvUtil.getEvn());
        return this.queryGenericDao.count(this.getEntityClass(), wrapper);
    }
}

