/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import com.alibaba.fastjson2.JSON;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.xml.sax.EntityResolver;
import tech.codingless.core.plugs.mybaties3.ConcurrentSqlCreatorLocker;
import tech.codingless.core.plugs.mybaties3.GenericQueryDao;
import tech.codingless.core.plugs.mybaties3.MyBatiesService;
import tech.codingless.core.plugs.mybaties3.SerializableFunction;
import tech.codingless.core.plugs.mybaties3.SqlLoader;
import tech.codingless.core.plugs.mybaties3.annotation.MyColumn;
import tech.codingless.core.plugs.mybaties3.annotation.OrderTypeEnum;
import tech.codingless.core.plugs.mybaties3.condition.ColumnSelector;
import tech.codingless.core.plugs.mybaties3.condition.QueryCondition;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionWrapper;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionWrapperParser;
import tech.codingless.core.plugs.mybaties3.conf.DataBaseConf;
import tech.codingless.core.plugs.mybaties3.data.BaseDO;
import tech.codingless.core.plugs.mybaties3.data.PageRollResult;
import tech.codingless.core.plugs.mybaties3.data.RowCount;
import tech.codingless.core.plugs.mybaties3.helper.AutoFindByIdBatchHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoFindByIdHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoGetHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoRollPageSelectSqlHelper;
import tech.codingless.core.plugs.mybaties3.helper.AutoSelectByConditionSqlHelper;
import tech.codingless.core.plugs.mybaties3.helper.CommonSQLHelper;
import tech.codingless.core.plugs.mybaties3.helper.MyTableColumnParser;
import tech.codingless.core.plugs.mybaties3.helper.MyTypeHanderRegistHelper;
import tech.codingless.core.plugs.mybaties3.helper.PrepareParameterHelper;
import tech.codingless.core.plugs.mybaties3.util.DataEnvUtil;
import tech.codingless.core.plugs.mybaties3.util.MybatiesMD5Util;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;
import tech.codingless.core.plugs.mybaties3.util.ReflectionUtil;

@Component
public class GenericQueryDAOImpl<T extends BaseDO>
implements GenericQueryDao<T> {
    private static final String NAMESPACE = "AUTOSQL";
    private static final Logger LOG = LoggerFactory.getLogger(GenericQueryDAOImpl.class);
    private static Map<String, ResultMap> RESULT_MAPS = new HashMap<String, ResultMap>();
    protected MyBatiesService myBatiesService;
    protected BasicDataSource basicDataSource;
    @Autowired(required=false)
    private DataBaseConf conf;
    private List<SqlLoader> sqlLoaders;

    @Autowired
    protected void setMyBatiesService(MyBatiesService myBatiesService) {
        LOG.info("\u6ce8\u5165\u6570\u636e\u8bbf\u95ee\u670d\u52a1:" + myBatiesService);
        this.myBatiesService = myBatiesService;
        if (this.conf != null && MybatiesStringUtil.isNotEmpty(this.conf.getUrl(), this.conf.getUsername(), this.conf.getPassword())) {
            this.basicDataSource = new BasicDataSource();
            this.basicDataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
            this.basicDataSource.setUrl(this.conf.getUrl());
            this.basicDataSource.setUsername(this.conf.getUsername());
            this.basicDataSource.setPassword(this.conf.getPassword());
            this.basicDataSource.setMaxIdle(30);
            this.basicDataSource.setMinIdle(3);
            this.basicDataSource.setMaxTotal(30);
            this.basicDataSource.setMaxWaitMillis(10L);
            this.basicDataSource.setInitialSize(3);
            this.basicDataSource.setRemoveAbandonedOnBorrow(true);
            this.basicDataSource.setRemoveAbandonedTimeout(180);
            LOG.info("\u751f\u6210BasicDataSource\uff1a" + this.basicDataSource);
        }
    }

    @Override
    public T selectOne(String sqlId, Object parameter) {
        return (T)((BaseDO)this.myBatiesService.selectOne(sqlId, parameter));
    }

    @Override
    public Object selectOneRow(String sqlId, Object param) {
        return this.myBatiesService.selectOne(sqlId, param);
    }

    @Override
    public List<T> selectList(String sqlId, Object param) {
        return this.myBatiesService.selectList(sqlId, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getEntity(Class<T> clazz, String id) {
        String sqlKey = "AUTOSQL.GET_" + CommonSQLHelper.getTableName(clazz);
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("id", id);
        param.put("env", DataEnvUtil.getEvn());
        try {
            return (T)((BaseDO)this.myBatiesService.selectOne(sqlKey, param));
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoGetHelper.genAutoSqlForGet(clazz, false, this.myBatiesService.getConfiguration());
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return (T)((BaseDO)this.myBatiesService.selectOne(sqlKey, param));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getEntity(Class<T> clazz, String id, String companyId) {
        String namespace = NAMESPACE;
        String sqlKey = "GET_BYCOMPANYID_" + CommonSQLHelper.getTableName(clazz);
        String sqlFullKey = namespace + "." + sqlKey;
        HashMap<String, Object> param = new HashMap<String, Object>(6);
        param.put("id", id);
        param.put("companyId", companyId);
        param.put("env", DataEnvUtil.getEvn());
        try {
            return (T)((BaseDO)this.myBatiesService.selectOne(sqlFullKey, param));
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlFullKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlFullKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlFullKey)) {
                        AutoFindByIdHelper.genGetSql(this.myBatiesService.getConfiguration(), namespace, sqlKey, clazz);
                        ConcurrentSqlCreatorLocker.put(sqlFullKey);
                    }
                }
            }
            return (T)((BaseDO)this.myBatiesService.selectOne(sqlFullKey, param));
        }
    }

    @Override
    public List<T> findEntityList(Class<T> clazz, String companyId, Collection<String> idList) {
        return this.findEntityList(clazz, companyId, idList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> findEntityList(Class<T> clazz, String companyId, Collection<String> idList, Collection<String> columns) {
        String sqlKey = "AUTOSQL.findEntityList_" + CommonSQLHelper.getTableName(clazz);
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", companyId);
            param.put("idList", idList);
            param.put("columns", columns);
            return this.myBatiesService.selectList(sqlKey, param);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoFindByIdBatchHelper.genBatchGetSql(this.myBatiesService.getConfiguration(), NAMESPACE, sqlKey, clazz);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("companyId", companyId);
            param.put("idList", idList);
            param.put("columns", columns);
            return this.myBatiesService.selectList(sqlKey, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> list(Class<T> clazz) {
        String sqlKey = "AUTOSQL.LIST_" + CommonSQLHelper.getTableName(clazz);
        try {
            return this.myBatiesService.selectList(sqlKey);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        this.genAutoSqlForList(clazz);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.selectList(sqlKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> select(Class<? extends BaseDO> clazz, Collection<String> columns, Collection<QueryCondition> conditions, int offset, int limit) {
        String tableName = CommonSQLHelper.getTableName(clazz);
        MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), clazz);
        String sqlKey = "AUTOSQL.selectByConditions_" + tableName;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("columns", columns);
        param.put("conditions", conditions);
        param.put("offset", offset);
        param.put("limit", limit);
        try {
            return this.myBatiesService.selectList(sqlKey, param);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoSelectByConditionSqlHelper.gen(this.myBatiesService.getConfiguration(), NAMESPACE, sqlKey, clazz);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.selectList(sqlKey, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(Class<? extends BaseDO> clazz, Collection<String> columns, Collection<QueryCondition> conditions) {
        String tableName = CommonSQLHelper.getTableName(clazz);
        MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), clazz);
        String sqlKey = "AUTOSQL.countByConditions_" + tableName;
        HashMap<String, Collection<Object>> param = new HashMap<String, Collection<Object>>();
        param.put("columns", columns);
        param.put("conditions", conditions);
        try {
            return (Integer)this.myBatiesService.selectOne(sqlKey, param);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        AutoSelectByConditionSqlHelper.genCount(this.myBatiesService.getConfiguration(), NAMESPACE, sqlKey, clazz);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return (Integer)this.myBatiesService.selectOne(sqlKey, param);
        }
    }

    private void genAutoSqlForList(Class<T> clazz) {
        MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), clazz);
        String sqlKey = "AUTOSQL.LIST_" + CommonSQLHelper.getTableName(clazz);
        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
        String listSQL = CommonSQLHelper.getListSQL(clazz);
        SqlSource sqlSource = sqlSourceBuilder.parse(listSQL, clazz, null);
        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.SELECT);
        ArrayList<ResultMapping> mappingList = new ArrayList<ResultMapping>();
        ArrayList<ResultMap> resultMapList = new ArrayList<ResultMap>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Object attrName = new String();
            if (methodName.startsWith("get")) {
                attrName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                attrName = methodName.substring(2);
            }
            attrName = ((String)attrName).substring(0, 1).toLowerCase() + ((String)attrName).substring(1);
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField((String)attrName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.name())) {
                    columnName = myColumn.name();
                }
            }
            catch (Exception filed) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat((String)attrName);
            }
            ResultMapping.Builder mappingBuilder = new ResultMapping.Builder(this.myBatiesService.getConfiguration(), (String)attrName);
            mappingBuilder.javaType(method.getReturnType());
            mappingBuilder.column(columnName);
            mappingList.add(mappingBuilder.build());
        }
        ResultMap.Builder mapBuilder = new ResultMap.Builder(this.myBatiesService.getConfiguration(), "AUTOSQL.LIST_MAP_" + clazz.getSimpleName(), clazz, mappingList);
        resultMapList.add(mapBuilder.build());
        builder.resultMaps(resultMapList);
        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> list(Class<T> clazz, String companyId) {
        String sqlKey = "AUTOSQL.LIST_BY_COMPANY_" + CommonSQLHelper.getTableName(clazz);
        try {
            return this.myBatiesService.selectList(sqlKey, companyId);
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        this.genAutoSqlForListByCompanyId(clazz);
                        ConcurrentSqlCreatorLocker.put(sqlKey);
                    }
                }
            }
            return this.myBatiesService.selectList(sqlKey, companyId);
        }
    }

    private void genAutoSqlForListByCompanyId(Class<T> clazz) {
        String sqlKey = "AUTOSQL.LIST_BY_COMPANY_" + CommonSQLHelper.getTableName(clazz);
        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
        String listSQL = CommonSQLHelper.getListByCompanySQL(clazz);
        SqlSource sqlSource = sqlSourceBuilder.parse(listSQL, clazz, null);
        MappedStatement.Builder builder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), sqlKey, sqlSource, SqlCommandType.SELECT);
        ArrayList<ResultMapping> mappingList = new ArrayList<ResultMapping>();
        ArrayList<ResultMap> resultMapList = new ArrayList<ResultMap>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Object attrName = new String();
            if (methodName.startsWith("get")) {
                attrName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                attrName = methodName.substring(2);
            }
            attrName = ((String)attrName).substring(0, 1).toLowerCase() + ((String)attrName).substring(1);
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField((String)attrName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.name())) {
                    columnName = myColumn.name();
                }
            }
            catch (Exception filed) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat((String)attrName);
            }
            ResultMapping.Builder mappingBuilder = new ResultMapping.Builder(this.myBatiesService.getConfiguration(), (String)attrName);
            mappingBuilder.javaType(method.getReturnType());
            mappingBuilder.column(columnName);
            mappingList.add(mappingBuilder.build());
        }
        ResultMap.Builder mapBuilder = new ResultMap.Builder(this.myBatiesService.getConfiguration(), "AUTOSQL.LIST_BY_COMPANY_MAP" + clazz.getSimpleName(), clazz, mappingList);
        resultMapList.add(mapBuilder.build());
        builder.resultMaps(resultMapList);
        this.myBatiesService.getConfiguration().addMappedStatement(builder.build());
    }

    private ResultMap createResultMap(Class clazz, String key) {
        MyTypeHanderRegistHelper.regist(this.myBatiesService.getConfiguration(), clazz);
        if (RESULT_MAPS.containsKey(key)) {
            return RESULT_MAPS.get(key);
        }
        ArrayList<ResultMapping> mappingList = new ArrayList<ResultMapping>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (MyTableColumnParser.needSkipMethodName(methodName)) continue;
            String attrName = MyTableColumnParser.methodName2attrName(methodName);
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField(attrName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.name())) {
                    columnName = myColumn.name();
                }
            }
            catch (Exception filed) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat(attrName);
            }
            ResultMapping.Builder mappingBuilder = new ResultMapping.Builder(this.myBatiesService.getConfiguration(), attrName);
            mappingBuilder.javaType(method.getReturnType());
            mappingBuilder.column(columnName);
            mappingList.add(mappingBuilder.build());
        }
        ResultMap.Builder mapBuilder = new ResultMap.Builder(this.myBatiesService.getConfiguration(), key, clazz, mappingList);
        return mapBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageRollResult<T> rollPage(Class<T> clazz, String companyId, T param, String orderColumn, OrderTypeEnum orderType, Integer size, Integer page) {
        size = size == null ? 20 : size;
        page = page == null ? 1 : page;
        Integer limit = size = Integer.valueOf(size > 500 ? 500 : (size < 1 ? 1 : size));
        Integer offset = (page - 1) * size;
        CommonSQLHelper.ExecuteSql selectSql = null;
        CommonSQLHelper.ExecuteSql countSql = null;
        T base = param;
        String selectSqlKey = null;
        String countSqlKey = null;
        PageRollResult result = new PageRollResult();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        ((BaseDO)base).setEnv(DataEnvUtil.getEvn());
        queryParam.put("companyId", companyId);
        queryParam.put("obj", param);
        queryParam.put("limit", limit);
        queryParam.put("offset", offset);
        queryParam.put("sortColumn", orderColumn);
        queryParam.put("sortType", orderType != null ? orderType.getCode() : null);
        try {
            selectSql = CommonSQLHelper.genSelectSqlSkipNullProperties(companyId, base, orderColumn, orderType, limit, offset);
            selectSqlKey = "AUTOSQL.rollpage_list_" + base.getClass().getName() + "_" + MybatiesMD5Util.md5Hex(selectSql.getSql());
            countSql = CommonSQLHelper.genCountSqlSkipNullProperties(companyId, base);
            countSqlKey = "AUTOSQL.rollpage_count_" + base.getClass().getName() + "_" + MybatiesMD5Util.md5Hex(selectSql.getSql());
            result.setList(this.myBatiesService.selectList(selectSqlKey, queryParam));
            RowCount rowCount = (RowCount)this.myBatiesService.selectOne(countSqlKey, queryParam);
            result.setTotalCount(rowCount != null ? rowCount.getTotalCount() : 0);
        }
        catch (Exception e) {
            Object object;
            SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(this.myBatiesService.getConfiguration());
            if (ConcurrentSqlCreatorLocker.notExist(selectSqlKey)) {
                object = ConcurrentSqlCreatorLocker.getLocker(selectSqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(selectSqlKey)) {
                        SqlSource selectSource = sqlSourceBuilder.parse(selectSql.getSql(), queryParam.getClass(), null);
                        MappedStatement.Builder selectBuilder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), selectSqlKey, selectSource, SqlCommandType.SELECT);
                        this.myBatiesService.getConfiguration().addMappedStatement(selectBuilder.build());
                        selectBuilder.resultMaps(Arrays.asList(this.createResultMap(clazz, "AUTOSQL.GET_MAP_LIST_" + clazz.getSimpleName())));
                        ConcurrentSqlCreatorLocker.put(selectSqlKey);
                    }
                }
            }
            if (ConcurrentSqlCreatorLocker.notExist(countSqlKey)) {
                object = ConcurrentSqlCreatorLocker.getLocker(countSqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(countSqlKey)) {
                        SqlSource countSource = sqlSourceBuilder.parse(countSql.getSql(), queryParam.getClass(), null);
                        MappedStatement.Builder countBuilder = new MappedStatement.Builder(this.myBatiesService.getConfiguration(), countSqlKey, countSource, SqlCommandType.SELECT);
                        this.myBatiesService.getConfiguration().addMappedStatement(countBuilder.build());
                        countBuilder.resultMaps(Arrays.asList(this.createResultMap(RowCount.class, "AUTOSQL.rowCount")));
                        ConcurrentSqlCreatorLocker.put(countSqlKey);
                    }
                }
            }
            result.setList(this.myBatiesService.selectList(selectSqlKey, queryParam));
            RowCount rowCount = (RowCount)this.myBatiesService.selectOne(countSqlKey, queryParam);
            result.setTotalCount(rowCount != null ? rowCount.getTotalCount() : 0);
        }
        result.setPageSize(size);
        result.setCurrentPage(page);
        result.setTotalPage(result.getTotalCount() == 0 ? 0 : (int)Math.ceil((double)result.getTotalCount().intValue() * 1.0 / (double)size.intValue()));
        return result;
    }

    @Override
    public PageRollResult<?> rollPage(String namespance, String id, Map<String, Object> param, Integer size, Integer page) {
        size = size == null ? 20 : size;
        page = page == null ? 1 : page;
        Integer limit = size = Integer.valueOf(size > 500 ? 500 : (size < 1 ? 1 : size));
        Integer offset = (page - 1) * size;
        PageRollResult result = new PageRollResult();
        param.put("_limit_", limit);
        param.put("_offset_", offset);
        String sqlId = namespance.concat(id);
        String selectKey = id + "__selectRollPage__";
        String countKey = id + "__count__";
        try {
            result.setList(this.myBatiesService.selectList(namespance.concat(selectKey), param));
            Integer rows = (Integer)this.myBatiesService.selectOne(namespance.concat(countKey), param);
            result.setTotalCount(rows != null ? rows : 0);
        }
        catch (Exception e) {
            MappedStatement stmt = this.myBatiesService.getConfiguration().getMappedStatement(sqlId);
            try {
                String xmlpath = stmt.getResource();
                xmlpath = xmlpath.substring(xmlpath.indexOf("[") + 1, xmlpath.indexOf("]"));
                if (xmlpath.startsWith("jar:")) {
                    xmlpath = xmlpath.substring(4);
                }
                String xml = null;
                if (xmlpath.contains("classes!")) {
                    String classpath = xmlpath.split("classes!")[1];
                    xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(classpath));
                } else {
                    xml = IOUtils.toString((InputStream)new FileInputStream(xmlpath));
                }
                AutoRollPageSelectSqlHelper.genSelectMapper(namespance, id, selectKey, countKey, this.myBatiesService.getConfiguration(), xml);
            }
            catch (Exception e2) {
                LOG.error("", (Throwable)e2);
            }
            result.setList(this.myBatiesService.selectList(namespance.concat(selectKey), param));
            Integer rows = (Integer)this.myBatiesService.selectOne(namespance.concat(countKey), param);
            result.setTotalCount(rows != null ? rows : 0);
        }
        result.setPageSize(size);
        result.setCurrentPage(page);
        result.setTotalPage(result.getTotalCount() == 0 ? 0 : (int)Math.ceil((double)result.getTotalCount().intValue() * 1.0 / (double)size.intValue()));
        return result;
    }

    @Override
    public <E> List<E> noShardingList(String statement, Object parameter) {
        return this.myBatiesService.selectListNoSharding(statement, parameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> selectOneNative(String prepareSql, List<Object> params) {
        try (Connection conn = this.basicDataSource.getConnection();){
            PreparedStatement pstmt = conn.prepareStatement(prepareSql);
            PrepareParameterHelper.bindParam(pstmt, params);
            ResultSet rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                int i = 0;
                while (true) {
                    if (i >= rsmd.getColumnCount()) {
                        HashMap<String, Object> hashMap = row;
                        return hashMap;
                    }
                    String columnName = rsmd.getColumnName(i + 1);
                    Object val = rs.getObject(i + 1);
                    row.put(columnName.toLowerCase(), val);
                    ++i;
                }
            }
            LOG.info("SQL:{},PARAM:{}", (Object)prepareSql, (Object)(!CollectionUtils.isEmpty(params) ? JSON.toJSONString(params) : "NONE"));
            return null;
        }
        catch (SQLException e) {
            LOG.error("insertNative", (Throwable)e);
        }
        return null;
    }

    @Autowired(required=false)
    public void registSqlLoader(List<SqlLoader> sqlLoaders) {
        LOG.info("\u52a0\u8f7d\u4e86sqlLoaders");
        this.sqlLoaders = sqlLoaders;
        sqlLoaders.forEach(sqlLoader -> LOG.info("sqlLoader:{}", sqlLoader));
    }

    @Override
    public List<Map<String, ?>> select(String selectId, Map<String, Object> param, int offset, int limit) {
        return this.select2(selectId, param, offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, ?>> select2(String selectId, Map<String, Object> param, int offset, int limit) {
        String namespace = selectId.split("[.]")[0];
        String id = selectId.split("[.]")[1];
        String sysSelectId = "external." + namespace + "." + selectId.trim().replace(".", "-");
        String realSelectId = selectId.trim().replace(".", "-");
        String realnamespace = "external." + namespace;
        if (param == null) {
            param = new HashMap<String, Object>();
            param.put("_offset_", offset);
            param.put("_limit_", limit);
        }
        try {
            return this.myBatiesService.selectList(sysSelectId, param);
        }
        catch (MyBatisSystemException e) {
            if (this.sqlLoaders == null) {
                return Collections.emptyList();
            }
            if (ConcurrentSqlCreatorLocker.notExist(sysSelectId)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sysSelectId);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sysSelectId)) {
                        String xml = null;
                        String[] selectIdSplit = new StringBuilder(selectId).reverse().toString().split("[.]", 2);
                        for (SqlLoader sqlLoader : this.sqlLoaders) {
                            xml = sqlLoader.load(namespace, id);
                            if (!MybatiesStringUtil.isNotEmpty(xml)) continue;
                            LOG.info("found sql by loader:{}, selectId:{}, sql->{}", new Object[]{sqlLoader.name(), selectId, xml});
                        }
                        if (MybatiesStringUtil.isEmpty(xml)) {
                            return Collections.emptyList();
                        }
                        try {
                            XPathParser xpath = new XPathParser((InputStream)new ByteArrayInputStream(xml.getBytes("utf-8")), true, this.myBatiesService.getConfiguration().getVariables(), (EntityResolver)new XMLMapperEntityResolver());
                            List selects = xpath.evalNode("/mapper").evalNodes("select");
                            XNode xnode = (XNode)selects.get(0);
                            XMLLanguageDriver xmlLanguageDriver = new XMLLanguageDriver();
                            SqlSource sqlsource = xmlLanguageDriver.createSqlSource(this.myBatiesService.getConfiguration(), xnode, HashMap.class);
                            MapperBuilderAssistant mapperBuilder = new MapperBuilderAssistant(this.myBatiesService.getConfiguration(), sysSelectId);
                            mapperBuilder.setCurrentNamespace(realnamespace);
                            mapperBuilder.addMappedStatement(realSelectId, sqlsource, StatementType.PREPARED, SqlCommandType.SELECT, null, null, null, HashMap.class, null, HashMap.class, null, false, false, false, null, null, null, null, (LanguageDriver)xmlLanguageDriver);
                            ConcurrentSqlCreatorLocker.put(sysSelectId);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            return this.myBatiesService.selectList(sysSelectId, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, ?>> select1(String selectId, Map<String, Object> param, int offset, int limit) {
        String namespace = selectId.split("[.]")[0];
        String id = selectId.split("[.]")[1];
        String sysSelectId = "external." + namespace + "." + selectId.trim().replace(".", "-");
        if (param == null) {
            param = new HashMap<String, Object>();
            param.put("_offset_", offset);
            param.put("_limit_", limit);
        }
        try {
            return this.myBatiesService.selectList(sysSelectId, param);
        }
        catch (MyBatisSystemException e) {
            if (this.sqlLoaders == null) {
                return Collections.emptyList();
            }
            if (ConcurrentSqlCreatorLocker.notExist(sysSelectId)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sysSelectId);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sysSelectId)) {
                        String sql = null;
                        for (SqlLoader sqlLoader : this.sqlLoaders) {
                            sql = sqlLoader.load(namespace, id);
                            if (!MybatiesStringUtil.isNotEmpty(sql)) continue;
                            LOG.info("found sql by loader:{}, selectId:{}, sql->{}", new Object[]{sqlLoader.name(), selectId, sql});
                        }
                        if (MybatiesStringUtil.isEmpty(sql)) {
                            return Collections.emptyList();
                        }
                        try {
                            XMLMapperBuilder selectMapperBuilder = new XMLMapperBuilder((InputStream)new ByteArrayInputStream(sql.toString().getBytes("utf-8")), this.myBatiesService.getConfiguration(), sysSelectId, new HashMap());
                            selectMapperBuilder.parse();
                        }
                        catch (UnsupportedEncodingException e1) {
                            LOG.error("select", (Throwable)e1);
                        }
                        ConcurrentSqlCreatorLocker.put(sysSelectId);
                    }
                }
            }
            return this.myBatiesService.selectList(sysSelectId, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> select(Class<T> entityClass, ColumnSelector<T> columns, QueryConditionWrapper<T> wrapper, SerializableFunction<T, Object> orderColumn, OrderTypeEnum orderType, int offset, int limit) {
        Object sql = QueryConditionWrapperParser.parse(entityClass, columns, wrapper);
        if (orderColumn != null && orderType != null) {
            sql = (String)sql + " order by #{_order_column_} #{_order_type_} ";
            Field filed = ReflectionUtil.findField(orderColumn);
            wrapper.getContext().put("_order_column_", filed.getName());
            wrapper.getContext().put("_order_type_", orderType.getCode());
        }
        sql = (String)sql + " limit #{_limit_} offset #{_offset_} ";
        String sqlId = "select_" + entityClass.getSimpleName() + "_" + MybatiesStringUtil.md5((String)sql);
        String sqlKey = NAMESPACE.concat(".").concat(sqlId);
        wrapper.getContext().put("_limit_", limit);
        wrapper.getContext().put("_offset_", offset);
        try {
            return this.myBatiesService.selectList(sqlKey, wrapper.getContext());
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        try {
                            String xml = QueryConditionWrapperParser.toXml(entityClass, NAMESPACE, columns, sqlId, (String)sql);
                            XMLMapperBuilder selectMapperBuilder = new XMLMapperBuilder((InputStream)new ByteArrayInputStream(xml.toString().getBytes("utf-8")), this.myBatiesService.getConfiguration(), sqlKey, new HashMap());
                            selectMapperBuilder.parse();
                            ConcurrentSqlCreatorLocker.put(sqlKey);
                        }
                        catch (Throwable e1) {
                            LOG.error("select error", (Throwable)e);
                        }
                    }
                }
            }
            return this.myBatiesService.selectList(sqlKey, wrapper.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Class<T> entityClass, QueryConditionWrapper<T> wrapper) {
        String sql = QueryConditionWrapperParser.parseCount(entityClass, wrapper);
        String sqlKey = "count_" + entityClass.getSimpleName() + "_" + MybatiesStringUtil.md5(sql);
        String namespace = NAMESPACE;
        String namespace2 = "AUTOSQL.";
        try {
            return (Long)this.myBatiesService.selectOne(namespace2.concat(sqlKey), wrapper.getContext());
        }
        catch (MyBatisSystemException e) {
            if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                Object object = ConcurrentSqlCreatorLocker.getLocker(sqlKey);
                synchronized (object) {
                    if (ConcurrentSqlCreatorLocker.notExist(sqlKey)) {
                        try {
                            String xml = QueryConditionWrapperParser.toCountXml(entityClass, namespace, sqlKey, sql);
                            XMLMapperBuilder selectMapperBuilder = new XMLMapperBuilder((InputStream)new ByteArrayInputStream(xml.toString().getBytes("utf-8")), this.myBatiesService.getConfiguration(), sqlKey, new HashMap());
                            selectMapperBuilder.parse();
                        }
                        catch (Throwable e1) {
                            LOG.error("select error", (Throwable)e);
                        }
                    }
                }
            }
            return (Long)this.myBatiesService.selectOne(namespace2.concat(sqlKey), wrapper.getContext());
        }
    }
}

