/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import tech.codingless.core.plugs.mybaties3.GenericUpdateDAOImpl;
import tech.codingless.core.plugs.mybaties3.MyBatiesService;
import tech.codingless.core.plugs.mybaties3.MyEmptyDataSourceTransactionManager;
import tech.codingless.core.plugs.mybaties3.MybatiesDataSourceFactory;
import tech.codingless.core.plugs.mybaties3.SqlmapLoaderFactory;
import tech.codingless.core.plugs.mybaties3.conf.DataBaseConf;
import tech.codingless.core.plugs.mybaties3.helper.PrepareParameterHelper;
import tech.codingless.core.plugs.mybaties3.strategy.DataSourceCreator;
import tech.codingless.core.plugs.mybaties3.util.MybatiesAssertUtil;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

@Order(value=1)
@Service
public final class MyBatiesServiceDefaultImpl
implements MyBatiesService {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUpdateDAOImpl.class);
    private SqlSessionTemplate noShardingSession;
    private SqlSessionTemplate session;
    @Autowired
    ApplicationContext context;
    @Autowired(required=false)
    DataSourceCreator dataSourceFactory;
    @Autowired(required=false)
    MybatiesDataSourceFactory mybatiesDataSourceFactory;
    @Autowired(required=false)
    SqlmapLoaderFactory sqlmapLoaderFactory;
    @Autowired(required=false)
    private DataBaseConf conf;

    @Autowired(required=false)
    void initDataBaseConfig(DataBaseConf conf) {
        LOG.info("Init DataBaseConf");
        this.init();
    }

    @Override
    public int update(String statement, Object parameter) {
        return this.session.update(statement, parameter);
    }

    @Override
    public int insert(String statement, Object parameter) {
        return this.session.insert(statement, parameter);
    }

    @Override
    public int delete(String statement, Object parameter) {
        return this.session.delete(statement, parameter);
    }

    @Override
    public Configuration getConfiguration() {
        return this.session.getConfiguration();
    }

    @Override
    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.session.selectOne(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement, Object parameter) {
        return this.session.selectList(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement) {
        return this.session.selectList(statement);
    }

    @Override
    public String init() {
        return "ok";
    }

    public Object initSessionAndTransaction() {
        try {
            LOG.info("\u5c1d\u8bd5\u521b\u5efa\u4e8b\u52a1\u7ba1\u7406\u5668!");
            DataSource dataSource = null;
            if (this.dataSourceFactory != null) {
                dataSource = this.dataSourceFactory.make();
                LOG.info("\u901a\u8fc7[" + this.dataSourceFactory + "]\u521b\u5efa\u6570\u636e\u6e90\uff1a" + dataSource);
            }
            if (dataSource == null && this.conf != null && MybatiesStringUtil.isNotEmpty(this.conf.getUrl(), this.conf.getUsername(), this.conf.getPassword())) {
                BasicDataSource basicDataSource = new BasicDataSource();
                basicDataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
                basicDataSource.setUrl(this.conf.getUrl());
                basicDataSource.setUsername(this.conf.getUsername());
                basicDataSource.setPassword(this.conf.getPassword());
                basicDataSource.setMaxIdle(20);
                basicDataSource.setMinIdle(3);
                basicDataSource.setMaxTotal(20);
                basicDataSource.setMaxWaitMillis(10000L);
                basicDataSource.setInitialSize(3);
                basicDataSource.setRemoveAbandonedOnBorrow(true);
                basicDataSource.setRemoveAbandonedTimeout(180);
                dataSource = basicDataSource;
                LOG.info("\u521b\u5efa\u6570\u636e\u6e90\uff1a" + dataSource);
            }
            if (dataSource == null) {
                return new MyEmptyDataSourceTransactionManager();
            }
            DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager();
            this.session = null;
            dataSourceTransactionManager.setDataSource(dataSource);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] xDefSqlMapper = this.sqlmapLoaderFactory != null ? this.sqlmapLoaderFactory.sqlMapperResource() : null;
            ArrayList<Resource> mergeSqlMappers = new ArrayList<Resource>();
            if (MybatiesStringUtil.isNotEmpty(this.conf.getClasspathMapper())) {
                List.of(this.conf.getClasspathMapper().split(",")).stream().filter(item -> MybatiesStringUtil.isNotEmpty(item)).forEach(item -> {
                    try {
                        mergeSqlMappers.addAll(Arrays.asList(resolver.getResources("classpath*:" + item)));
                    }
                    catch (Exception e) {
                        LOG.error("load mapper fail ", (Throwable)e);
                    }
                });
            }
            if (xDefSqlMapper != null) {
                mergeSqlMappers.addAll(Arrays.asList(xDefSqlMapper));
            }
            Resource[] mergedResourceList = mergeSqlMappers.toArray(new Resource[0]);
            SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
            sqlSessionFactoryBean.setDataSource(dataSource);
            sqlSessionFactoryBean.setMapperLocations(mergedResourceList);
            sqlSessionFactoryBean.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
            SqlSessionFactoryBean factoryBean = sqlSessionFactoryBean;
            this.session = new SqlSessionTemplate((SqlSessionFactory)factoryBean.getObject());
            LOG.info("\u521d\u59cb\u5316\u4e8b\u52a1\u7ba1\u7406\u5668(\u6dfb\u52a0\u5230Spring\u5bb9\u5668\u4e2d)\uff1a " + dataSourceTransactionManager);
            if (this.mybatiesDataSourceFactory != null) {
                DataSource noShardingDatasource = this.mybatiesDataSourceFactory.make();
                SqlSessionFactoryBean noShardingFb = new SqlSessionFactoryBean();
                noShardingFb.setDataSource(noShardingDatasource);
                noShardingFb.setMapperLocations(mergedResourceList);
                noShardingFb.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
                SqlSessionFactoryBean noShardingBean = noShardingFb;
                this.noShardingSession = new SqlSessionTemplate((SqlSessionFactory)noShardingBean.getObject());
                LOG.info("\u521d\u59cb\u5316 No-Sharding Session:" + this.noShardingSession);
            }
            LOG.info("\u4e8b\u52a1\u7ba1\u7406\u5668:" + dataSourceTransactionManager);
            return dataSourceTransactionManager;
        }
        catch (Exception e) {
            LOG.error("\u521b\u5efa\u4e8b\u52a1", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdateSql(String sql, List<Object> param) {
        try {
            PreparedStatement ps = this.session.getConnection().prepareStatement(sql);
            PrepareParameterHelper.bindParam(ps, param);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            LOG.error("\u6267\u884cSQL\u51fa\u9519", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            try {
                this.session.getConnection().close();
            }
            catch (SQLException e) {
                LOG.error("close Connection ", (Throwable)e);
            }
        }
    }

    @Override
    public <E> List<E> selectListNoSharding(String statement, Object parameter) {
        MybatiesAssertUtil.assertNotNull(this.noShardingSession, "NO-SHARDING-SESSION-NOT-EXIST:\u672a\u5206\u7247\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        return this.noShardingSession.selectList(statement, parameter);
    }
}

