/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tech.codingless.core.plugs.mybaties3.GenericQueryDao;
import tech.codingless.core.plugs.mybaties3.MyBatiesService;
import tech.codingless.core.plugs.mybaties3.QueryService;
import tech.codingless.core.plugs.mybaties3.TableAutoCreateServiceMysqlImpl;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

@Service
public class QueryServiceImpl
implements QueryService {
    private static final Logger LOG = LoggerFactory.getLogger(TableAutoCreateServiceMysqlImpl.class);
    private static ConcurrentHashMap<String, Boolean> SAFE_SQLID_MAP = new ConcurrentHashMap();
    @Autowired
    private GenericQueryDao queryDao;
    @Autowired
    private MyBatiesService myBatiesService;

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public List<Map<String, Object>> list(QueryService.Parameter parameter) {
        if (MybatiesStringUtil.isEmpty(parameter.getSqlId())) {
            return null;
        }
        if (!SAFE_SQLID_MAP.containsKey(parameter.getSqlId())) {
            MappedStatement stmt = this.myBatiesService.getConfiguration().getMappedStatement(parameter.getSqlId());
            parameter.addAttribute("offset", 0);
            parameter.addAttribute("limit", 0);
            if (stmt.getSqlSource().getBoundSql((Object)parameter.getMap()).getSql().toUpperCase().startsWith("SELECT")) {
                SAFE_SQLID_MAP.put(parameter.getSqlId(), true);
            }
        }
        if (!SAFE_SQLID_MAP.containsKey(parameter.getSqlId())) {
            LOG.error("sql\u8bed\u53e5[" + parameter.getSqlId() + "]\u53ef\u80fd\u4e0d\u5b58\u5728,\u6216\u662f\u4e0d\u5b89\u5168!");
            return null;
        }
        int offset = (parameter.getPageNumber() - 1) * parameter.getPageSize();
        parameter.addAttribute("offset", offset);
        parameter.addAttribute("limit", parameter.getPageSize());
        return this.queryDao.selectList(parameter.getSqlId(), parameter.getMap());
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public int count(QueryService.Parameter parameter) {
        MappedStatement stmt;
        if (MybatiesStringUtil.isEmpty(parameter.getSqlId())) {
            return 0;
        }
        if (!SAFE_SQLID_MAP.containsKey(parameter.getSqlId()) && (stmt = this.myBatiesService.getConfiguration().getMappedStatement(parameter.getSqlId())).getSqlSource().getBoundSql((Object)parameter.getMap()).getSql().toUpperCase().startsWith("SELECT")) {
            SAFE_SQLID_MAP.put(parameter.getSqlId(), true);
        }
        if (!SAFE_SQLID_MAP.containsKey(parameter.getSqlId())) {
            LOG.error("sql\u8bed\u53e5[" + parameter.getSqlId() + "]\u53ef\u80fd\u4e0d\u5b58\u5728,\u6216\u662f\u4e0d\u5b89\u5168!");
            return 0;
        }
        return (Integer)this.queryDao.selectOneRow(parameter.getSqlId(), parameter.getMap());
    }

    public String getString(Map map, String key, String defaultStr) {
        if (map.containsKey(key)) {
            return map.get(key).toString();
        }
        return defaultStr;
    }
}

