/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.condition;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.List;
import tech.codingless.core.plugs.mybaties3.condition.QueryCondition;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionEnums;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class ConditionHelper {
    public static List<QueryCondition> parse(String conditionDoc) {
        if (MybatiesStringUtil.isEmpty(conditionDoc)) {
            return new ArrayList<QueryCondition>(2);
        }
        ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>();
        JSONObject json = JSON.parseObject((String)conditionDoc);
        for (String column : json.keySet()) {
            JSONObject oneColumnCondition = json.getJSONObject(column);
            for (String op : oneColumnCondition.keySet()) {
                Object val = oneColumnCondition.get(op);
                if (val == null || val instanceof String && MybatiesStringUtil.isEmpty((String)val)) continue;
                QueryCondition condition = new QueryCondition();
                condition.setColumnName(column);
                conditionList.add(condition);
                if ("eq".equalsIgnoreCase(op)) {
                    condition.setValue(val);
                    condition.setType(QueryConditionEnums.EQ);
                    continue;
                }
                if ("in".equalsIgnoreCase(op) && val instanceof JSONArray) {
                    JSONArray values = (JSONArray)val;
                    condition.setValues(List.of(values.toArray()));
                    condition.setType(QueryConditionEnums.IN);
                    continue;
                }
                if ("gt".equalsIgnoreCase(op)) {
                    condition.setValue(val);
                    condition.setType(QueryConditionEnums.GT);
                    continue;
                }
                if ("lt".equalsIgnoreCase(op)) {
                    condition.setValue(val);
                    condition.setType(QueryConditionEnums.LT);
                    continue;
                }
                if (!"is".equalsIgnoreCase(op) || !(val instanceof Boolean)) continue;
                condition.setValue(val);
                condition.setType(QueryConditionEnums.IS);
            }
        }
        return conditionList;
    }
}

