/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.condition;

import java.util.Collection;
import tech.codingless.core.plugs.mybaties3.condition.BaseQueryWrapper;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionEnums;
import tech.codingless.core.plugs.mybaties3.condition.QueryConditionRelEnums;

public class QueryCondition
implements BaseQueryWrapper {
    private static final String AND = " and ";
    private static final String EQ = " = ";
    private static final String BEGIN_ATTR = "  #{";
    private static final String CLOSE_ATTR = "} ";
    private static final String IS_NULL = " is null ";
    private static final String IS_NOT_NULL = " is not null ";
    private static final String GT = " &gt; ";
    private static final String LT = " &lt; ";
    private static final String BETWEEN = " between ";
    public static final String PROP_NAME_ENDFIX_BEFORE = "_before_";
    public static final String PROP_NAME_ENDFIX_AFTER = "_after_";
    public static final String PROP_NAME_ENDFIX_MIN = "_min_";
    public static final String PROP_NAME_ENDFIX_MAX = "_max_";
    public static final String PROP_NAME_ENDFIX_LT = "_lt_";
    public static final String PROP_NAME_ENDFIX_GT = "_gt_";
    private boolean hasPreCondition;
    String propName;
    String columnName;
    Object value;
    Collection<Object> values;
    Long min;
    Long max;
    QueryConditionEnums type;
    QueryConditionRelEnums rel;

    public StringBuilder toSql() {
        StringBuilder builder = new StringBuilder();
        if (this.hasPreCondition) {
            builder.append(AND);
        }
        if (QueryConditionEnums.GT == this.type) {
            builder.append(this.getColumnName()).append(GT).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_GT).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.LT == this.type) {
            builder.append(this.getColumnName()).append(LT).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_LT).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.EQ == this.type) {
            builder.append(this.getColumnName()).append(EQ).append(BEGIN_ATTR).append(this.getPropName()).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.IS == this.type) {
            builder.append(this.getColumnName()).append(EQ).append(BEGIN_ATTR).append(this.getPropName()).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.IS_NULL == this.type) {
            builder.append(this.getColumnName()).append(IS_NULL);
        } else if (QueryConditionEnums.IS_NOT_NULL == this.type) {
            builder.append(this.getColumnName()).append(IS_NOT_NULL);
        } else if (QueryConditionEnums.BETWEEN == this.type) {
            builder.append(this.getColumnName()).append(BETWEEN).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_MIN).append(CLOSE_ATTR);
            builder.append(AND).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_MAX).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.IN == this.type) {
            builder.append(this.getColumnName()).append(" in ");
            builder.append("<foreach item=\"").append("item").append("\" collection=\"").append(this.getPropName()).append("\" index=\"index\" open=\"(\" separator=\",\" close=\")\">");
            builder.append("#{item}").append("</foreach>");
        } else if (QueryConditionEnums.BEFORE == this.type) {
            builder.append(this.getColumnName()).append(GT).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_BEFORE).append(CLOSE_ATTR);
        } else if (QueryConditionEnums.AFTER == this.type) {
            builder.append(this.getColumnName()).append(LT).append(BEGIN_ATTR).append(this.getPropName()).append(PROP_NAME_ENDFIX_AFTER).append(CLOSE_ATTR);
        }
        return builder;
    }

    public boolean isHasPreCondition() {
        return this.hasPreCondition;
    }

    public String getPropName() {
        return this.propName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Object getValue() {
        return this.value;
    }

    public Collection<Object> getValues() {
        return this.values;
    }

    public Long getMin() {
        return this.min;
    }

    public Long getMax() {
        return this.max;
    }

    public QueryConditionEnums getType() {
        return this.type;
    }

    public QueryConditionRelEnums getRel() {
        return this.rel;
    }

    public void setHasPreCondition(boolean hasPreCondition) {
        this.hasPreCondition = hasPreCondition;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValues(Collection<Object> values) {
        this.values = values;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public void setType(QueryConditionEnums type) {
        this.type = type;
    }

    public void setRel(QueryConditionRelEnums rel) {
        this.rel = rel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryCondition)) {
            return false;
        }
        QueryCondition other = (QueryCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasPreCondition() != other.isHasPreCondition()) {
            return false;
        }
        Long this$min = this.getMin();
        Long other$min = other.getMin();
        if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
            return false;
        }
        Long this$max = this.getMax();
        Long other$max = other.getMax();
        if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
            return false;
        }
        String this$propName = this.getPropName();
        String other$propName = other.getPropName();
        if (this$propName == null ? other$propName != null : !this$propName.equals(other$propName)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Collection<Object> this$values = this.getValues();
        Collection<Object> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        QueryConditionEnums this$type = this.getType();
        QueryConditionEnums other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        QueryConditionRelEnums this$rel = this.getRel();
        QueryConditionRelEnums other$rel = other.getRel();
        return !(this$rel == null ? other$rel != null : !((Object)((Object)this$rel)).equals((Object)other$rel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasPreCondition() ? 79 : 97);
        Long $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
        Long $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        String $propName = this.getPropName();
        result = result * 59 + ($propName == null ? 43 : $propName.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Collection<Object> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        QueryConditionEnums $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        QueryConditionRelEnums $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : ((Object)((Object)$rel)).hashCode());
        return result;
    }

    public String toString() {
        return "QueryCondition(hasPreCondition=" + this.isHasPreCondition() + ", propName=" + this.getPropName() + ", columnName=" + this.getColumnName() + ", value=" + this.getValue() + ", values=" + this.getValues() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", type=" + this.getType() + ", rel=" + this.getRel() + ")";
    }
}

