/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.codingless.core.plugs.mybaties3.annotation.MyColumn;
import tech.codingless.core.plugs.mybaties3.helper.CommonSQLHelper;
import tech.codingless.core.plugs.mybaties3.helper.MyTypeHanderRegistHelper;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class AutoGetHelper {
    private static final Logger log = LoggerFactory.getLogger(AutoGetHelper.class);

    public static void genAutoSqlForGet(Class<?> clazz, boolean userCompanyId, Configuration configuration) {
        MyTypeHanderRegistHelper.regist(configuration, clazz);
        String sqlKey = null;
        sqlKey = userCompanyId ? "AUTOSQL.GET_BYCOMPANYID_" + CommonSQLHelper.getTableName(clazz) : "AUTOSQL.GET_" + CommonSQLHelper.getTableName(clazz);
        SqlSourceBuilder sqlSourceBuilder = new SqlSourceBuilder(configuration);
        String getSQL = userCompanyId ? CommonSQLHelper.getGetSQLByCompanyId(clazz) : CommonSQLHelper.getGetSQL(clazz);
        SqlSource sqlSource = sqlSourceBuilder.parse(getSQL, clazz, null);
        MappedStatement.Builder builder = new MappedStatement.Builder(configuration, sqlKey, sqlSource, SqlCommandType.SELECT);
        ArrayList<ResultMapping> mappingList = new ArrayList<ResultMapping>();
        ArrayList<ResultMap> resultMapList = new ArrayList<ResultMap>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Object attrName = new String();
            if (methodName.startsWith("get")) {
                attrName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                attrName = methodName.substring(2);
            }
            attrName = ((String)attrName).substring(0, 1).toLowerCase() + ((String)attrName).substring(1);
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField((String)attrName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.name())) {
                    columnName = myColumn.name();
                }
            }
            catch (Exception filed) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat((String)attrName);
            }
            ResultMapping.Builder mappingBuilder = new ResultMapping.Builder(configuration, (String)attrName);
            mappingBuilder.javaType(method.getReturnType());
            mappingBuilder.column(columnName);
            mappingList.add(mappingBuilder.build());
        }
        ResultMap.Builder mapBuilder = new ResultMap.Builder(configuration, "AUTOSQL.GET_MAP_" + clazz.getSimpleName(), clazz, mappingList);
        resultMapList.add(mapBuilder.build());
        builder.resultMaps(resultMapList);
        try {
            configuration.addMappedStatement(builder.build());
        }
        catch (Exception e) {
            log.error("genAutoSqlForGet Fail", (Throwable)e);
        }
    }
}

