/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.helper;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.StringTypeHandler;
import tech.codingless.core.plugs.mybaties3.annotation.MyColumn;
import tech.codingless.core.plugs.mybaties3.annotation.MyComment;
import tech.codingless.core.plugs.mybaties3.helper.CommonSQLHelper;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class MyTableColumnParser {
    private static final ConcurrentHashMap<String, Boolean> SKIP_PROPS = new ConcurrentHashMap();

    public static List<ColumnProp> parse(Class<?> clazz) {
        ArrayList<ColumnProp> list = new ArrayList<ColumnProp>();
        for (Method method : clazz.getMethods()) {
            String methodName = method.getName();
            if (methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            Object attrName = new String();
            if (methodName.startsWith("get")) {
                attrName = methodName.substring(3);
            }
            if (methodName.startsWith("is")) {
                attrName = methodName.substring(2);
            }
            attrName = ((String)attrName).substring(0, 1).toLowerCase() + ((String)attrName).substring(1);
            String columnName = null;
            ColumnProp columnProp = new ColumnProp();
            try {
                MyColumn myColumn;
                Field filed = clazz.getDeclaredField((String)attrName);
                MyComment myComment = filed.getAnnotation(MyComment.class);
                if (myComment != null) {
                    columnProp.setComment(myComment.value());
                }
                if ((myColumn = filed.getAnnotation(MyColumn.class)) != null && myColumn.virtual()) continue;
                if (myColumn != null && MybatiesStringUtil.isNotEmpty(myColumn.name())) {
                    columnName = myColumn.name();
                }
                if (myColumn != null) {
                    if (!StringTypeHandler.class.getName().equals(myColumn.typeHandler().getName())) {
                        columnProp.setTypeHandler(myColumn.typeHandler());
                    }
                    columnProp.setReadonly(myColumn.readonly());
                    columnProp.setVirturl(myColumn.virtual());
                    String type = myColumn.type().toUpperCase().trim();
                    if (type.startsWith("VARCHAR")) {
                        columnProp.setJdbcType(JdbcType.VARCHAR);
                    } else if (type.startsWith("INT")) {
                        columnProp.setJdbcType(JdbcType.INTEGER);
                    } else if (type.startsWith("DECIMAL")) {
                        columnProp.setJdbcType(JdbcType.DECIMAL);
                    } else {
                        columnProp.setJdbcType(JdbcType.VARCHAR);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat((String)attrName);
            }
            columnProp.setColumn(columnName);
            columnProp.setProp((String)attrName);
            columnProp.setJavaTypeClass(method.getReturnType());
            list.add(columnProp);
        }
        return list;
    }

    public static boolean isDefaultSupportType(Class<?> clazz) {
        if (clazz.getName().startsWith("java.")) {
            return true;
        }
        return clazz.getName().equalsIgnoreCase("boolean");
    }

    public static List<ColumnProp> parseSkipNull(Class<?> clazz, Object entity) throws Exception {
        ArrayList<ColumnProp> list = new ArrayList<ColumnProp>();
        for (Method method : clazz.getMethods()) {
            Object val;
            String attrName;
            String methodName = method.getName();
            if (MyTableColumnParser.needSkipMethodName(methodName) || MyTableColumnParser.needSkipProperties(attrName = MyTableColumnParser.methodName2attrName(methodName)) || (val = method.invoke(entity, new Object[0])) == null) continue;
            String columnName = null;
            try {
                Field filed = clazz.getDeclaredField(attrName);
                MyColumn myColumn = filed.getAnnotation(MyColumn.class);
                if (myColumn != null) {
                    if (myColumn.readonly()) continue;
                    columnName = MybatiesStringUtil.isNotEmpty(myColumn.name()) ? myColumn.name() : columnName;
                }
            }
            catch (Exception filed) {
                // empty catch block
            }
            ColumnProp columnProp = new ColumnProp();
            if (MybatiesStringUtil.isEmpty(columnName)) {
                columnName = CommonSQLHelper.change2dbFormat(attrName);
            }
            columnProp.setColumn(columnName);
            columnProp.setProp(attrName);
            columnProp.setJavaTypeClass(method.getReturnType());
            columnProp.setVal(val);
            list.add(columnProp);
        }
        return list;
    }

    public static boolean needSkipMethodName(String methodName) {
        return methodName.equals("getClass") || !methodName.startsWith("get") && !methodName.startsWith("is");
    }

    public static boolean needSkipProperties(String propName) {
        return SKIP_PROPS.containsKey(propName);
    }

    public static String methodName2attrName(String methodName) {
        Object pName = new String();
        if (methodName.startsWith("get")) {
            pName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            pName = methodName.substring(2);
        }
        pName = ((String)pName).substring(0, 1).toLowerCase() + ((String)pName).substring(1);
        return pName;
    }

    static {
        SKIP_PROPS.put("id", true);
        SKIP_PROPS.put("gmtCreate", true);
        SKIP_PROPS.put("gmtWrite", true);
        SKIP_PROPS.put("del", true);
        SKIP_PROPS.put("ownerId", true);
        SKIP_PROPS.put("createUid", true);
        SKIP_PROPS.put("companyId", true);
        SKIP_PROPS.put("ver", true);
    }

    public static class ColumnProp {
        private String column;
        private String prop;
        private Class<?> javaTypeClass;
        private Class<?> typeHandler;
        private JdbcType jdbcType;
        private Object val;
        private String comment;
        private boolean virturl;
        private boolean readonly;

        public String getColumn() {
            return this.column;
        }

        public String getProp() {
            return this.prop;
        }

        public Class<?> getJavaTypeClass() {
            return this.javaTypeClass;
        }

        public Class<?> getTypeHandler() {
            return this.typeHandler;
        }

        public JdbcType getJdbcType() {
            return this.jdbcType;
        }

        public Object getVal() {
            return this.val;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isVirturl() {
            return this.virturl;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setProp(String prop) {
            this.prop = prop;
        }

        public void setJavaTypeClass(Class<?> javaTypeClass) {
            this.javaTypeClass = javaTypeClass;
        }

        public void setTypeHandler(Class<?> typeHandler) {
            this.typeHandler = typeHandler;
        }

        public void setJdbcType(JdbcType jdbcType) {
            this.jdbcType = jdbcType;
        }

        public void setVal(Object val) {
            this.val = val;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setVirturl(boolean virturl) {
            this.virturl = virturl;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnProp)) {
                return false;
            }
            ColumnProp other = (ColumnProp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isVirturl() != other.isVirturl()) {
                return false;
            }
            if (this.isReadonly() != other.isReadonly()) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            String this$prop = this.getProp();
            String other$prop = other.getProp();
            if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
                return false;
            }
            Class<?> this$javaTypeClass = this.getJavaTypeClass();
            Class<?> other$javaTypeClass = other.getJavaTypeClass();
            if (this$javaTypeClass == null ? other$javaTypeClass != null : !this$javaTypeClass.equals(other$javaTypeClass)) {
                return false;
            }
            Class<?> this$typeHandler = this.getTypeHandler();
            Class<?> other$typeHandler = other.getTypeHandler();
            if (this$typeHandler == null ? other$typeHandler != null : !this$typeHandler.equals(other$typeHandler)) {
                return false;
            }
            JdbcType this$jdbcType = this.getJdbcType();
            JdbcType other$jdbcType = other.getJdbcType();
            if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
                return false;
            }
            Object this$val = this.getVal();
            Object other$val = other.getVal();
            if (this$val == null ? other$val != null : !this$val.equals(other$val)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnProp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isVirturl() ? 79 : 97);
            result = result * 59 + (this.isReadonly() ? 79 : 97);
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            String $prop = this.getProp();
            result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
            Class<?> $javaTypeClass = this.getJavaTypeClass();
            result = result * 59 + ($javaTypeClass == null ? 43 : $javaTypeClass.hashCode());
            Class<?> $typeHandler = this.getTypeHandler();
            result = result * 59 + ($typeHandler == null ? 43 : $typeHandler.hashCode());
            JdbcType $jdbcType = this.getJdbcType();
            result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
            Object $val = this.getVal();
            result = result * 59 + ($val == null ? 43 : $val.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }

        public String toString() {
            return "MyTableColumnParser.ColumnProp(column=" + this.getColumn() + ", prop=" + this.getProp() + ", javaTypeClass=" + this.getJavaTypeClass() + ", typeHandler=" + this.getTypeHandler() + ", jdbcType=" + this.getJdbcType() + ", val=" + this.getVal() + ", comment=" + this.getComment() + ", virturl=" + this.isVirturl() + ", readonly=" + this.isReadonly() + ")";
        }
    }
}

