/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.helper;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.codingless.core.plugs.mybaties3.helper.MyTableColumnParser;

public class MyTypeHanderRegistHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MyTypeHanderRegistHelper.class);
    private static ConcurrentHashMap<Class<?>, Boolean> CACHE = new ConcurrentHashMap();

    public static void regist(Configuration configuration, Class<?> clazz) {
        if (CACHE.containsKey(clazz)) {
            return;
        }
        MyTableColumnParser.parse(clazz).forEach(columnProp -> {
            try {
                if (MyTableColumnParser.isDefaultSupportType(columnProp.getJavaTypeClass())) {
                    return;
                }
                if (columnProp.getTypeHandler() != null) {
                    TypeHandlerRegistry registry = configuration.getTypeHandlerRegistry();
                    if (registry.hasTypeHandler(columnProp.getTypeHandler())) {
                        return;
                    }
                    LOG.info("Regist Type Hander {}", columnProp.getTypeHandler());
                    configuration.getTypeHandlerRegistry().register(columnProp.getJavaTypeClass(), columnProp.getJdbcType(), columnProp.getTypeHandler());
                }
            }
            catch (Throwable e) {
                CACHE.remove(clazz);
                LOG.error("Regist Type Hander Error", e);
            }
        });
        CACHE.put(clazz, true);
    }
}

