/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.helper;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class PrepareParameterHelper {
    public static void bindParam(PreparedStatement pstmt, List<Object> params) throws SQLException {
        if (!CollectionUtils.isEmpty(params)) {
            for (int i = 0; i < params.size(); ++i) {
                Object param = params.get(i);
                int paramIndex = i + 1;
                if (param == null) {
                    pstmt.setNull(paramIndex, 0);
                    continue;
                }
                if (param instanceof String) {
                    pstmt.setString(paramIndex, (String)param);
                    continue;
                }
                if (param instanceof Integer) {
                    pstmt.setInt(paramIndex, (Integer)param);
                    continue;
                }
                if (param instanceof Double) {
                    pstmt.setDouble(paramIndex, (Double)param);
                    continue;
                }
                if (param instanceof Long) {
                    pstmt.setLong(paramIndex, (Long)param);
                    continue;
                }
                if (param instanceof Date) {
                    pstmt.setDate(paramIndex, new java.sql.Date(((Date)param).getTime()));
                    continue;
                }
                if (param instanceof BigDecimal) {
                    pstmt.setBigDecimal(paramIndex, (BigDecimal)param);
                    continue;
                }
                if (param instanceof Float) {
                    pstmt.setFloat(paramIndex, ((Float)param).floatValue());
                    continue;
                }
                if (param instanceof Boolean) {
                    pstmt.setBoolean(paramIndex, (Boolean)param);
                    continue;
                }
                pstmt.setString(paramIndex, param.toString());
            }
        }
    }
}

