/*
 * Decompiled with CFR 0.152.
 */
package tech.codingless.core.plugs.mybaties3.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import tech.codingless.core.plugs.mybaties3.util.MybatiesStringUtil;

public class LockerUtil {
    private static final ConcurrentHashMap<String, Locker> LOCKER_MAP = new ConcurrentHashMap();
    private static final Locker WHOLE_LOCKER = new Locker();

    public static List<Locker> getLockers(String ... keys) {
        if (keys == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key2 : keys) {
            if (!MybatiesStringUtil.isNotEmpty(key2)) continue;
            list.add(key2);
        }
        Collections.sort(list);
        ArrayList<Locker> lockers = new ArrayList<Locker>();
        list.forEach(key -> lockers.add(LockerUtil.getLocker(key)));
        return lockers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locker getLocker(String key) {
        if (LOCKER_MAP.containsKey(key)) {
            Locker locker = LOCKER_MAP.get(key);
            return locker;
        }
        Locker locker = WHOLE_LOCKER;
        synchronized (locker) {
            if (LOCKER_MAP.containsKey(key)) {
                Locker locker2 = LOCKER_MAP.get(key);
                return locker2;
            }
            Locker locker3 = new Locker();
            locker3.setKey(key);
            LOCKER_MAP.put(key, locker3);
            return locker3;
        }
    }

    public static class Locker
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        private long t;
        private String key;

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setT(long t) {
            this.t = t;
        }

        public long getT() {
            return this.t;
        }

        @Override
        public void lock() {
            super.lock();
            this.t = System.currentTimeMillis();
        }
    }
}

