package tech.codingzen

/**
 * @param A part0 type
 * @param B part1 type
 * @param C part2 type
 * @param D part3 type
 * @param [part0] a value held by the tuple
 * @param [part1] a value held by the tuple
 * @param [part2] a value held by the tuple
 * @param [part3] a value held by the tuple
 */
data class Tuple4<A, B, C, D>(val part0: A, val part1: B, val part2: C, val part3: D)

/**
 * @param A part0 type
 * @param B part1 type
 * @param C part2 type
 * @param D part3 type
 * @param E part4 type
 * @param [part0] a value held by the tuple
 * @param [part1] a value held by the tuple
 * @param [part2] a value held by the tuple
 * @param [part3] a value held by the tuple
 * @param [part4] a value held by the tuple
 */
data class Tuple5<A, B, C, D, E>(val part0: A, val part1: B, val part2: C, val part3: D, val part4: E)

/**
 * @param A part0 type
 * @param B part1 type
 * @param C part2 type
 * @param D part3 type
 * @param E part4 type
 * @param F part5 type
 * @param [part0] a value held by the tuple
 * @param [part1] a value held by the tuple
 * @param [part2] a value held by the tuple
 * @param [part3] a value held by the tuple
 * @param [part4] a value held by the tuple
 * @param [part5] a value held by the tuple
 */
data class Tuple6<A, B, C, D, E, F>(val part0: A, val part1: B, val part2: C, val part3: D, val part4: E, val part5: F)

/**
 * @param A part0 type
 * @param B part1 type
 * @param C part2 type
 * @param D part3 type
 * @param E part4 type
 * @param F part5 type
 * @param G part6 type
 * @param [part0] a value held by the tuple
 * @param [part1] a value held by the tuple
 * @param [part2] a value held by the tuple
 * @param [part3] a value held by the tuple
 * @param [part4] a value held by the tuple
 * @param [part5] a value held by the tuple
 * @param [part6] a value held by the tuple
 */
data class Tuple7<A, B, C, D, E, F, G>(
    val part0: A, val part1: B, val part2: C, val part3: D, val part4: E, val part5: F,
    val part6: G
)

/**
 * @param A part0 type
 * @param B part1 type
 * @param C part2 type
 * @param D part3 type
 * @param E part4 type
 * @param F part5 type
 * @param G part6 type
 * @param H part7 type
 * @param [part0] a value held by the tuple
 * @param [part1] a value held by the tuple
 * @param [part2] a value held by the tuple
 * @param [part3] a value held by the tuple
 * @param [part4] a value held by the tuple
 * @param [part5] a value held by the tuple
 * @param [part6] a value held by the tuple
 * @param [part7] a value held by the tuple
 */
data class Tuple8<A, B, C, D, E, F, G, H>(
    val part0: A, val part1: B, val part2: C, val part3: D, val part4: E, val part5: F,
    val part6: G, val part7: H
)

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    block: (Pair<A, B>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.map { b -> block(Pair(a, b)) }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    block: (Triple<A, B, C>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.map { c -> block(Triple(a, b, c)) }
        }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param D partD type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [partD] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, D, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    partD: Either<L, D>,
    block: (Tuple4<A, B, C, D>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.bind { c ->
                partD.map { d -> block(Tuple4(a, b, c, d)) }
            }
        }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param D partD type
 * @param E partE type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [partD] one of the parts to bind
 * @param [partE] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, D, E, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    partD: Either<L, D>,
    partE: Either<L, E>,
    block: (Tuple5<A, B, C, D, E>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.bind { c ->
                partD.bind { d ->
                    partE.map { e -> block(Tuple5(a, b, c, d, e)) }
                }
            }
        }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param D partD type
 * @param E partE type
 * @param F partF type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [partD] one of the parts to bind
 * @param [partE] one of the parts to bind
 * @param [partF] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, D, E, F, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    partD: Either<L, D>,
    partE: Either<L, E>,
    partF: Either<L, F>,
    block: (Tuple6<A, B, C, D, E, F>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.bind { c ->
                partD.bind { d ->
                    partE.bind { e ->
                        partF.map { f -> block(Tuple6(a, b, c, d, e, f)) }
                    }
                }
            }
        }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param D partD type
 * @param E partE type
 * @param F partF type
 * @param G partG type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [partD] one of the parts to bind
 * @param [partE] one of the parts to bind
 * @param [partF] one of the parts to bind
 * @param [partG] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, D, E, F, G, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    partD: Either<L, D>,
    partE: Either<L, E>,
    partF: Either<L, F>,
    partG: Either<L, G>,
    block: (Tuple7<A, B, C, D, E, F, G>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.bind { c ->
                partD.bind { d ->
                    partE.bind { e ->
                        partF.bind { f ->
                            partG.map { g -> block(Tuple7(a, b, c, d, e, f, g)) }
                        }
                    }
                }
            }
        }
    }

/**
 * @param L lpartFt type
 * @param A partA type
 * @param B partB type
 * @param C partC type
 * @param D partD type
 * @param E partE type
 * @param F partF type
 * @param G partG type
 * @param H partG type
 * @param R result type
 * @param [partA] one of the parts to bind
 * @param [partB] one of the parts to bind
 * @param [partC] one of the parts to bind
 * @param [partD] one of the parts to bind
 * @param [partE] one of the parts to bind
 * @param [partF] one of the parts to bind
 * @param [partG] one of the parts to bind
 * @param [partH] one of the parts to bind
 * @param [block] function that accepts all the part values and maps them to a result
 * @return the bind'ing of all the parts.  All parts must be Either right containers each holding a value to be passed
 * to [block]
 */
inline fun <L, A, B, C, D, E, F, G, H, R> bindAll(
    partA: Either<L, A>,
    partB: Either<L, B>,
    partC: Either<L, C>,
    partD: Either<L, D>,
    partE: Either<L, E>,
    partF: Either<L, F>,
    partG: Either<L, G>,
    partH: Either<L, H>,
    block: (Tuple8<A, B, C, D, E, F, G, H>) -> R
): Either<L, R> =
    partA.bind { a ->
        partB.bind { b ->
            partC.bind { c ->
                partD.bind { d ->
                    partE.bind { e ->
                        partF.bind { f ->
                            partG.bind { g ->
                                partH.map { h -> block(Tuple8(a, b, c, d, e, f, g, h)) }
                            }
                        }
                    }
                }
            }
        }
    }