/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;

public class Utils {
    public static ResultOfConvertAddress convertAddress(Context ctx, String address, AddressStringFormat outputFormat) throws EverSdkException {
        return ctx.call("utils.convert_address", new ParamsOfConvertAddress(address, outputFormat), ResultOfConvertAddress.class);
    }

    public static ResultOfGetAddressType getAddressType(Context ctx, String address) throws EverSdkException {
        return ctx.call("utils.get_address_type", new ParamsOfGetAddressType(address), ResultOfGetAddressType.class);
    }

    public static ResultOfCalcStorageFee calcStorageFee(Context ctx, String account, Number period) throws EverSdkException {
        return ctx.call("utils.calc_storage_fee", new ParamsOfCalcStorageFee(account, period), ResultOfCalcStorageFee.class);
    }

    public static ResultOfCompressZstd compressZstd(Context ctx, String uncompressed, Number level) throws EverSdkException {
        return ctx.call("utils.compress_zstd", new ParamsOfCompressZstd(uncompressed, level), ResultOfCompressZstd.class);
    }

    public static ResultOfDecompressZstd decompressZstd(Context ctx, String compressed) throws EverSdkException {
        return ctx.call("utils.decompress_zstd", new ParamsOfDecompressZstd(compressed), ResultOfDecompressZstd.class);
    }

    public record ParamsOfConvertAddress(String address, AddressStringFormat outputFormat) {
    }

    public static interface AddressStringFormat {
        public static final AccountId ACCOUNTID = new AccountId();
        public static final Hex HEX = new Hex();

        public record AccountId() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Hex() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Base64(Boolean url, Boolean test, Boolean bounce) implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record ResultOfConvertAddress(String address) {
    }

    public record ParamsOfGetAddressType(String address) {
    }

    public record ResultOfGetAddressType(AccountAddressType addressType) {
    }

    public record ParamsOfCalcStorageFee(String account, Number period) {
    }

    public record ResultOfCalcStorageFee(String fee) {
    }

    public record ParamsOfCompressZstd(String uncompressed, Number level) {
    }

    public record ResultOfCompressZstd(String compressed) {
    }

    public record ParamsOfDecompressZstd(String compressed) {
    }

    public record ResultOfDecompressZstd(String decompressed) {
    }

    public static enum AccountAddressType {
        AccountId,
        Hex,
        Base64;

    }
}

