/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import tech.deplant.java4ever.binding.AppSigningBox;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Unstable;

public final class Debot {
    @Unstable
    public static RegisteredDebot init(Context ctx, String address, AppSigningBox appObject) throws EverSdkException {
        return ctx.callAppObject("debot.init", new ParamsOfInit(address), appObject, RegisteredDebot.class);
    }

    @Unstable
    public static void start(Context ctx, Integer debotHandle) throws EverSdkException {
        ctx.callVoid("debot.start", new ParamsOfStart(debotHandle));
    }

    @Unstable
    public static ResultOfFetch fetch(Context ctx, String address) throws EverSdkException {
        return ctx.call("debot.fetch", new ParamsOfFetch(address), ResultOfFetch.class);
    }

    @Unstable
    public static void execute(Context ctx, Integer debotHandle, DebotAction action) throws EverSdkException {
        ctx.callVoid("debot.execute", new ParamsOfExecute(debotHandle, action));
    }

    @Unstable
    public static void send(Context ctx, Integer debotHandle, String message) throws EverSdkException {
        ctx.callVoid("debot.send", new ParamsOfSend(debotHandle, message));
    }

    @Unstable
    public static void remove(Context ctx, Integer debotHandle) throws EverSdkException {
        ctx.callVoid("debot.remove", new ParamsOfRemove(debotHandle));
    }

    public record ParamsOfInit(String address) {
    }

    public record RegisteredDebot(Integer debotHandle, String debotAbi, DebotInfo info) {
    }

    public record ParamsOfStart(Integer debotHandle) {
    }

    public record ParamsOfFetch(String address) {
    }

    public record ResultOfFetch(DebotInfo info) {
    }

    public record ParamsOfExecute(Integer debotHandle, DebotAction action) {
    }

    public record DebotAction(String description, String name, Integer actionType, Integer to, String attributes, String misc) {
    }

    public record ParamsOfSend(Integer debotHandle, String message) {
    }

    public record ParamsOfRemove(Integer debotHandle) {
    }

    public static enum DebotErrorCode {
        DebotStartFailed(801),
        DebotFetchFailed(802),
        DebotExecutionFailed(803),
        DebotInvalidHandle(804),
        DebotInvalidJsonParams(805),
        DebotInvalidFunctionId(806),
        DebotInvalidAbi(807),
        DebotGetMethodFailed(808),
        DebotInvalidMsg(809),
        DebotExternalCallFailed(810),
        DebotBrowserCallbackFailed(811),
        DebotOperationRejected(812),
        DebotNoCode(813);

        private final Integer value;

        private DebotErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record DebotInfo(String name, String version, String publisher, String caption, String author, String support, String hello, String language, String dabi, String icon, String[] interfaces, String dabiversion) {
    }

    public static sealed interface DebotActivity {

        public record Transaction(String msg, String dst, Spending[] out, Long fee, Boolean setcode, String signkey, Integer signingBoxHandle) implements DebotActivity
        {
            @JsonProperty(value="type")
            public String type() {
                return "Transaction";
            }
        }
    }

    public static sealed interface ParamsOfAppDebotBrowser {

        public record Approve(DebotActivity activity) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Approve";
            }
        }

        public record Send(String message) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Send";
            }
        }

        public record InvokeDebot(String debotAddr, DebotAction action) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "InvokeDebot";
            }
        }

        public record GetSigningBox() implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetSigningBox";
            }
        }

        public record Input(String prompt) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Input";
            }
        }

        public record ShowAction(DebotAction action) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "ShowAction";
            }
        }

        public record SwitchCompleted() implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "SwitchCompleted";
            }
        }

        public record Switch(Integer contextId) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Switch";
            }
        }

        public record Log(String msg) implements ParamsOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Log";
            }
        }
    }

    public static sealed interface ResultOfAppDebotBrowser {

        public record Approve(Boolean approved) implements ResultOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Approve";
            }
        }

        public record InvokeDebot() implements ResultOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "InvokeDebot";
            }
        }

        public record GetSigningBox(Integer signingBox) implements ResultOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "GetSigningBox";
            }
        }

        public record Input(String value) implements ResultOfAppDebotBrowser
        {
            @JsonProperty(value="type")
            public String type() {
                return "Input";
            }
        }
    }

    public record Spending(Long amount, String dst) {
    }
}

